package com.biz.crm.mdm.business.customer.material.local.event;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialEventDto;
import com.biz.crm.mdm.business.customer.material.sdk.event.CustomerMaterialEventListener;
import com.biz.crm.mdm.business.customer.material.sdk.vo.CustomerMaterialVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/26 14:53
 * @ClassName CustomerMaterialEventListenerImpl
 * @Description TODO 客户物料事件监听
 */
@Component
public class CustomerMaterialEventListenerImpl implements CustomerMaterialEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新建事件监听
     * @param customerMaterialEventDto
     */
    @Override
    public void onCreate(CustomerMaterialEventDto customerMaterialEventDto) {
        CustomerMaterialVo newest = customerMaterialEventDto.getNewest();
        CustomerMaterialVo original = customerMaterialEventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除事件监听
     * @param customerMaterialEventDto
     */
    @Override
    public void onDelete(CustomerMaterialEventDto customerMaterialEventDto) {
        CustomerMaterialVo newest = customerMaterialEventDto.getNewest();
        CustomerMaterialVo original = customerMaterialEventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新事件监听
     * @param customerMaterialEventDto
     */
    @Override
    public void onUpdate(CustomerMaterialEventDto customerMaterialEventDto) {
        CustomerMaterialVo newest = customerMaterialEventDto.getNewest();
        CustomerMaterialVo original = customerMaterialEventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 禁用事件监听
     * @param customerMaterialEventDto
     */
    @Override
    public void onDisable(CustomerMaterialEventDto customerMaterialEventDto) {
        this.onUpdate(customerMaterialEventDto);
    }

    /**
     * 启用事件监听
     * @param customerMaterialEventDto
     */
    @Override
    public void onEnable(CustomerMaterialEventDto customerMaterialEventDto) {
        this.onUpdate(customerMaterialEventDto);
    }
}
