package com.biz.crm.mdm.business.customer.material.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.mapper.CustomerMaterialMapper;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 客户物料 的 数据库访问类 {@link CustomerMaterial}
 *
 * @author jerry7
 */
@Component
public class CustomerMaterialRepository extends ServiceImpl<CustomerMaterialMapper, CustomerMaterial> {

  /**
   * 分页条件查询客户物料
   *
   * @param pageable 分页信息
   * @param dto      查询筛选条件
   * @return 分页数据
   */
  public Page<CustomerMaterial> findByConditions(Page<CustomerMaterial> pageable, @Param("dto") CustomerMaterialDto dto) {
    //新增租户编号
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(pageable, dto);
  }


  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<CustomerMaterial> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    updateWrapper.eq("tenant_code", TenantUtils.getTenantCode());    //新增租户编号判断条件
    this.update(updateWrapper);
  }

  /**
   * 根据主键集合，修改 del_flag
   *
   * @param delFlagStatusEnum 删除标记
   * @param ids               主键id集合
   */
  public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<CustomerMaterial> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("del_flag", delFlagStatusEnum.getCode());
    updateWrapper.in("id", ids);
    updateWrapper.eq("tenant_code",TenantUtils.getTenantCode());    //新增租户编号判断条件
    this.update(updateWrapper);
  }

  /**
   * 通过客户组织编码集合查询
   *
   * @param customerOrgCodes
   * @param delCode
   * @return
   */
  public List<CustomerMaterial> findByCustomerOrgCodes(List<String> customerOrgCodes, String delCode) {
   return this.lambdaQuery()
       .eq(CustomerMaterial::getDelFlag,delCode)
       .eq(CustomerMaterial::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
       .in(CustomerMaterial::getCustomerOrgCode,customerOrgCodes)
       .list();
  }

  /**
   * 重构查询方法 通过id和租户编号查询
   * @param id
   * @param tenantCode
   * @return
   */
  public CustomerMaterial findByIdAndTenantCode(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerMaterial::getTenantCode,tenantCode)
        .in(CustomerMaterial::getId,id)
        .one();
  }

  /**
   * 重构修改方法  通过id和租户编号修改
   * @param customerMaterial
   * @param tenantCode
   */
  public void updateByIdAndTenantCode(CustomerMaterial customerMaterial, String tenantCode) {
    LambdaUpdateWrapper<CustomerMaterial>lambdaUpdateWrapper= Wrappers.lambdaUpdate();
    lambdaUpdateWrapper.eq(CustomerMaterial::getTenantCode,tenantCode);
    lambdaUpdateWrapper.in(CustomerMaterial::getId,customerMaterial.getId());
    this.baseMapper.update(customerMaterial,lambdaUpdateWrapper);
  }

  public List<CustomerMaterial> findByIds(List<String> ids) {
    return this.lambdaQuery()
            .eq(CustomerMaterial::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
            .in(CustomerMaterial::getId,ids)
            .list();
  }
}
