/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.material.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.repository.CustomerMaterialRepository;
import com.biz.crm.mdm.business.customer.material.local.service.CustomerMaterialService;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialEventDto;
import com.biz.crm.mdm.business.customer.material.sdk.event.CustomerMaterialEventListener;
import com.biz.crm.mdm.business.customer.material.sdk.vo.CustomerMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerMaterialServiceImpl
implements CustomerMaterialService {
    @Autowired(required=false)
    private CustomerMaterialRepository customerMaterialRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<CustomerMaterial> findByConditions(Pageable pageable, CustomerMaterialDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerMaterialDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.customerMaterialRepository.findByConditions((Page<CustomerMaterial>)page, dto);
    }

    @Override
    public CustomerMaterial findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerMaterialRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomerMaterial create(CustomerMaterial customerMaterial) {
        this.createValidate(customerMaterial);
        customerMaterial.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        customerMaterial.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        customerMaterial.setCreateTime(new Date());
        customerMaterial.setCreateAccount(this.loginUserService.getLoginAccountName());
        customerMaterial.setTenantCode(TenantUtils.getTenantCode());
        this.customerMaterialRepository.save((Object)customerMaterial);
        CustomerMaterialEventDto customerMaterialEventDto = new CustomerMaterialEventDto();
        CustomerMaterialVo nowVo = (CustomerMaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerMaterial, CustomerMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        customerMaterialEventDto.setNewest(nowVo);
        customerMaterialEventDto.setOriginal(null);
        SerializableBiConsumer & Serializable onCreate = CustomerMaterialEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerMaterialEventDto, CustomerMaterialEventListener.class, (SerializableBiConsumer)onCreate);
        return customerMaterial;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomerMaterial update(CustomerMaterial customerMaterial) {
        Validate.notNull((Object)((Object)customerMaterial), (String)"\u66f4\u65b0\u5ba2\u6237\u7269\u6599\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerMaterial.getId(), (String)"\u66f4\u65b0\u65f6\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustomerMaterial entity = this.customerMaterialRepository.findByIdAndTenantCode(customerMaterial.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)entity), (String)"\u5f85\u66f4\u65b0\u7684\u5ba2\u6237\u7269\u6599\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.createValidate(customerMaterial);
        this.customerMaterialRepository.updateByIdAndTenantCode(customerMaterial, TenantUtils.getTenantCode());
        customerMaterial.setModifyTime(new Date());
        customerMaterial.setModifyAccount(this.loginUserService.getLoginAccountName());
        CustomerMaterialEventDto customerMaterialEventDto = new CustomerMaterialEventDto();
        CustomerMaterialVo nowVo = (CustomerMaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerMaterial, CustomerMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        customerMaterialEventDto.setNewest(nowVo);
        CustomerMaterialVo original = (CustomerMaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CustomerMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        customerMaterialEventDto.setOriginal(original);
        SerializableBiConsumer & Serializable onUpdate = CustomerMaterialEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerMaterialEventDto, CustomerMaterialEventListener.class, (SerializableBiConsumer)onUpdate);
        return customerMaterial;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerMaterial> customerMaterials = this.customerMaterialRepository.findByIds(ids);
        this.customerMaterialRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (!CollectionUtils.isEmpty(customerMaterials)) {
            customerMaterials.forEach(customerMaterial -> {
                CustomerMaterialEventDto customerMaterialEventDto = new CustomerMaterialEventDto();
                CustomerMaterialVo original = (CustomerMaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerMaterial, CustomerMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
                customerMaterialEventDto.setNewest(null);
                customerMaterialEventDto.setOriginal(original);
                SerializableBiConsumer & Serializable onDelete = CustomerMaterialEventListener::onDelete;
                this.nebulaNetEventClient.publish((NebulaEventDto)customerMaterialEventDto, CustomerMaterialEventListener.class, (SerializableBiConsumer)onDelete);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerMaterial> customerMaterials = this.customerMaterialRepository.findByIds(ids);
        this.customerMaterialRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(customerMaterials)) {
            customerMaterials.forEach(customerMaterial -> {
                CustomerMaterialEventDto customerMaterialEventDto = new CustomerMaterialEventDto();
                CustomerMaterialVo original = new CustomerMaterialVo();
                original.setId(customerMaterial.getId());
                original.setEnableStatus(customerMaterial.getEnableStatus());
                CustomerMaterialVo nowVo = new CustomerMaterialVo();
                nowVo.setId(customerMaterial.getId());
                nowVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                customerMaterialEventDto.setNewest(nowVo);
                customerMaterialEventDto.setOriginal(original);
                SerializableBiConsumer & Serializable onEnable = CustomerMaterialEventListener::onEnable;
                this.nebulaNetEventClient.publish((NebulaEventDto)customerMaterialEventDto, CustomerMaterialEventListener.class, (SerializableBiConsumer)onEnable);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerMaterial> customerMaterials = this.customerMaterialRepository.findByIds(ids);
        this.customerMaterialRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(customerMaterials)) {
            customerMaterials.forEach(customerMaterial -> {
                CustomerMaterialEventDto customerMaterialEventDto = new CustomerMaterialEventDto();
                CustomerMaterialVo original = new CustomerMaterialVo();
                original.setId(customerMaterial.getId());
                original.setEnableStatus(customerMaterial.getEnableStatus());
                CustomerMaterialVo nowVo = new CustomerMaterialVo();
                nowVo.setId(customerMaterial.getId());
                nowVo.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
                customerMaterialEventDto.setNewest(nowVo);
                customerMaterialEventDto.setOriginal(original);
                SerializableBiConsumer & Serializable onDisable = CustomerMaterialEventListener::onDisable;
                this.nebulaNetEventClient.publish((NebulaEventDto)customerMaterialEventDto, CustomerMaterialEventListener.class, (SerializableBiConsumer)onDisable);
            });
        }
    }

    @Override
    public List<CustomerMaterial> findByCustomerOrgCodes(List<String> customerOrgCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(customerOrgCodes) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.customerMaterialRepository.findByCustomerOrgCodes(customerOrgCodes, DelFlagStatusEnum.NORMAL.getCode());
    }

    public void createValidate(CustomerMaterial customerMaterial) {
        Validate.notNull((Object)((Object)customerMaterial), (String)"\u65b0\u589e\u5ba2\u6237\u7269\u6599\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerMaterial.getCustomerOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerMaterial.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerMaterial.getBarCode(), (String)"\u6761\u5f62\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((customerMaterial.getMaterialCode().length() <= 64 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5ba2\u6237\u7269\u6599\u65f6\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        Validate.isTrue((customerMaterial.getCustomerOrgCode().length() <= 64 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5ba2\u6237\u7269\u6599\u65f6\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
        Validate.isTrue((customerMaterial.getMaterialCode().length() <= 64 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5ba2\u6237\u7269\u6599\u65f6\u6761\u5f62\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764", (Object[])new Object[0]);
    }
}

