package com.biz.crm.mdm.business.customer.material.local.service.notifier;

import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.service.CustomerMaterialService;
import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe: 客户物料 客户组织事件监听实现
 * @createTime 2022年02月16日 17:57:00
 */
@Component
public class CusMatCustomerOrgEventListenerImpl implements CustomerOrgEventListener {
  @Autowired(required = false)
  private CustomerMaterialService customerMaterialService;


  @Override
  public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  /**
   * 当客户组织发生删除事件时，根据触发事件的客户组织编码,验证客户组织是否存在与客户物料的关联关系。
   * <p>
   * 1.存在与客户物料的关联关系,则抛出组织已关联客户物料的异常,阻断当前客户组织的删除操作
   * 2.不存在与客户物料的关联关系,则什么也不做.
   */
  @Override
  public void onBatchDelete(List<CustomerOrgVo> customerOrgVos) {
    if (CollectionUtils.isEmpty(customerOrgVos)) {
      return;
    }
    List<String> customerOrgCodes = customerOrgVos.stream().map(CustomerOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(customerOrgCodes)){
      return;
    }
    List<CustomerMaterial> list = customerMaterialService.findByCustomerOrgCodes(customerOrgCodes);
    Validate.isTrue(CollectionUtils.isEmpty(list),"存在与客户物料的绑定关系不能删除");
  }

  @Override
  public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchDisable(List<CustomerOrgVo> eventDtos) {
    //do nothing
  }
}
