package com.biz.crm.mdm.business.customer.material.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.service.CustomerMaterialService;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户物料Controller相关http
 *
 * @author jerry7
 */
@Api(tags = "客户物料")
@RestController
@RequestMapping("/v1/customerMaterial/customerMaterial")
public class CustomerMaterialController {

  @Autowired(required = false)
  private CustomerMaterialService customerMaterialService;

  @ApiOperation(value = "分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<CustomerMaterial>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         CustomerMaterialDto customerMaterialDto) {
    return Result.ok(this.customerMaterialService.findByConditions(pageable, customerMaterialDto));
  }

  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<CustomerMaterial> findById(@RequestParam String id) {
    return Result.ok(this.customerMaterialService.findById(id));
  }

  /**
   * 新增
   */
  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result<CustomerMaterial> create(@RequestBody CustomerMaterial customerMaterial) {
    return Result.ok(this.customerMaterialService.create(customerMaterial));
  }

  /**
   * 更新
   */
  @ApiOperation(value = "更新")
  @PatchMapping("")
  public Result<CustomerMaterial> update(@RequestBody CustomerMaterial customerMaterial) {
    return Result.ok(this.customerMaterialService.update(customerMaterial));
  }

  /**
   * 批量删除
   */
  @ApiOperation(value = "批量删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> delete(@RequestParam List<String> ids) {
    customerMaterialService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

  /**
   * 批量启用
   */

  @ApiOperation(value = "批量启用")
  @PatchMapping("/enableBatch")
  public Result<?> enable(@RequestBody List<String> ids) {
    customerMaterialService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  /**
   * 批量禁用
   */
  @ApiOperation(value = "批量禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disable(@RequestBody List<String> ids) {
    customerMaterialService.disableBatch(ids);
    return Result.ok("禁用成功");
  }
}
