/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.material.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.material.local.entity.CustomerMaterial;
import com.biz.crm.mdm.business.customer.material.local.mapper.CustomerMaterialMapper;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerMaterialRepository
extends ServiceImpl<CustomerMaterialMapper, CustomerMaterial> {
    public Page<CustomerMaterial> findByConditions(Page<CustomerMaterial> pageable, @Param(value="dto") CustomerMaterialDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerMaterialMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        updateWrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)delFlagStatusEnum.getCode());
        updateWrapper.in((Object)"id", ids);
        updateWrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public List<CustomerMaterial> findByCustomerOrgCodes(List<String> customerOrgCodes, String delCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)delCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CustomerMaterial::getCustomerOrgCode, customerOrgCodes)).list();
    }

    public CustomerMaterial findByIdAndTenantCode(String id, String tenantCode) {
        return (CustomerMaterial)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void updateByIdAndTenantCode(CustomerMaterial customerMaterial, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{customerMaterial.getId()});
        ((CustomerMaterialMapper)this.baseMapper).update((Object)customerMaterial, (Wrapper)lambdaUpdateWrapper);
    }

    public List<CustomerMaterial> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }
}

