package com.biz.crm.mdm.business.customer.material.sdk.event;

import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/26 14:45
 * @ClassName CustomerMaterialEventListener
 * @Description TODO
 */
public interface CustomerMaterialEventListener extends NebulaEvent {
    /**
     * 创建事件
     */
    default void onCreate(CustomerMaterialEventDto customerMaterialEventDto){}

    /**
     * 删除事件
     *
     * @param customerMaterialEventDto
     */
    default void onDelete(CustomerMaterialEventDto customerMaterialEventDto){}

    /**
     * 更新事件
     *
     * @param customerMaterialEventDto
     */
    default void onUpdate(CustomerMaterialEventDto customerMaterialEventDto){}

    /**
     * 禁用事件
     *
     * @param customerMaterialEventDto
     */
    default void onDisable(CustomerMaterialEventDto customerMaterialEventDto){}

    /**
     * 开启事件
     * @param customerMaterialEventDto
     */
    default void onEnable(CustomerMaterialEventDto customerMaterialEventDto){}
}
