package com.biz.crm.mdm.business.customer.material.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/26 14:48
 * @ClassName CustomerMaterialVo
 * @Description TODO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户物料信息VO")
public class CustomerMaterialVo extends TenantFlagOpVo {
    /**
     * 客户组织编码
     */
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;

    /**
     * 条形码
     */
    @ApiModelProperty("条形码")
    private String barCode;

    /** 开始时间 */
    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    /** 结束时间 */
    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;


}
