package com.biz.crm.mdm.business.customer.org.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-28 17:43.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgLazyTreeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 迁移原/baseLazyTreeController/customerOrgLazyTree接口
 * @program: crm
 * @description: 客户组织：LazyTreeVo：客户组织懒加载树
 * @author: Bao Hongbin
 * @create: 2021-10-28 17:43
 **/

@Api(tags = "客户组织：LazyTreeVo：客户组织懒加载树")
@Slf4j
@RestController
@RequestMapping("/v1/customerOrg/lazyTree")
public class CustomerOrgLazyTreeVoController {

  @Autowired(required = false)
  private CustomerOrgLazyTreeVoService customerOrgLazyTreeVoService;

  @ApiOperation(value = "客户组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，" +
      "传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
  @GetMapping
  public Result<List<LazyTreeVo>> findLazyTree(@ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
    try {
      List<LazyTreeVo> result = this.customerOrgLazyTreeVoService.findLazyTree(treeDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
