package com.biz.crm.mdm.business.customer.org.local.service;

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPositionBindDto;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-10-27 17:51.
 */
public interface CustomerOrgPositionVoService {


  /**
   * 删除客户组织与职位的关联
   *
   * @param ids
   */
  void unbindPosition(List<String> ids);


  /**
   * 创建客户组织与职位的关联
   *
   * @param customerOrgPositionBindDto
   */
  void bindPosition(CustomerOrgPositionBindDto customerOrgPositionBindDto);

  /**
   * 通过客户组织编码集合查找与职位的关联关系
   *
   * @param customerOrgCodes
   * @return
   */
  List<CustomerOrgPosition> findListByCustomerOrgCodes(List<String> customerOrgCodes);
}
