package com.biz.crm.mdm.business.customer.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 10:21.
 */

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @program: crm
 * @description: 客户组织vo SDK 服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 10:21
 **/
@Service
public class CustomerOrgVoSdkServiceImpl implements CustomerOrgVoSdkService {
  @Autowired(required = false)
  private CustomerOrgRepository customerOrgRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<CustomerOrgVo> findListByCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return new ArrayList<>();
    }
    List<CustomerOrg> customerOrgs = customerOrgRepository.findListByCodes(codes, TenantUtils.getTenantCode());
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(customerOrgs, CustomerOrg.class
        , CustomerOrgVo.class, HashSet.class, ArrayList.class));
  }
}
