/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgVoService;
import com.biz.crm.mdm.business.customer.org.local.service.helper.CustomerOrgServiceHelper;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgCreateDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventBatchDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventUpdateDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPaginationDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgUpdateDto;
import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgNebulaEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerOrgVoServiceImpl
implements CustomerOrgVoService {
    @Autowired(required=false)
    private CustomerOrgRepository customerOrgRepository;
    @Autowired(required=false)
    private CustomerOrgServiceHelper helper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<CustomerOrgVo> findByConditions(Pageable pageable, CustomerOrgPaginationDto customerOrgPaginationDto) {
        CustomerOrg one;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        customerOrgPaginationDto = Optional.ofNullable(customerOrgPaginationDto).orElse(new CustomerOrgPaginationDto());
        customerOrgPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)customerOrgPaginationDto.getUnderCustomerOrgCode()) && (one = this.customerOrgRepository.findDetailsByCode(customerOrgPaginationDto.getUnderCustomerOrgCode(), customerOrgPaginationDto.getTenantCode())) != null) {
            customerOrgPaginationDto.setUnderThisRuleCode(one.getRuleCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)customerOrgPaginationDto.getNotUnderCustomerOrgCode()) && (one = this.customerOrgRepository.findDetailsByCode(customerOrgPaginationDto.getNotUnderCustomerOrgCode(), customerOrgPaginationDto.getTenantCode())) != null) {
            customerOrgPaginationDto.setNotUnderThisRuleCode(one.getRuleCode());
        }
        List selectedCodeList = Optional.ofNullable(customerOrgPaginationDto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)customerOrgPaginationDto.getSelectedCode())) {
            selectedCodeList.add(customerOrgPaginationDto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            customerOrgPaginationDto.setSelectedCodeList(selectedCodeList);
        }
        return this.customerOrgRepository.findByConditions(pageable, customerOrgPaginationDto);
    }

    @Override
    public CustomerOrgVo findDetailsById(String id) {
        CustomerOrg parent;
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        CustomerOrg one = this.customerOrgRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (one == null) {
            return null;
        }
        CustomerOrgVo respVo = (CustomerOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)one.getParentCode()) && (parent = this.customerOrgRepository.findDetailsByCode(one.getParentCode(), TenantUtils.getTenantCode())) != null) {
            respVo.setParentName(parent.getCustomerOrgName());
        }
        return respVo;
    }

    @Override
    @Transactional
    public CustomerOrgVo create(CustomerOrgCreateDto customerOrgCreateDto) {
        return this.createForm(customerOrgCreateDto);
    }

    private CustomerOrgVo createForm(CustomerOrgCreateDto customerOrgCreateDto) {
        this.helper.createValidation(customerOrgCreateDto);
        if (StringUtils.isBlank((CharSequence)customerOrgCreateDto.getParentCode())) {
            customerOrgCreateDto.setParentCode(null);
        }
        CustomerOrg customerOrg = (CustomerOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrgCreateDto, CustomerOrg.class, HashSet.class, ArrayList.class, new String[0]));
        customerOrg.setTenantCode(TenantUtils.getTenantCode());
        customerOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        customerOrg.setEnableStatus(null != customerOrg.getEnableStatus() ? customerOrg.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)customerOrgCreateDto.getCustomerOrgCode())) {
            customerOrg.setCustomerOrgCode((String)this.generateCode.generateCode("KHZZ", 1).get(0));
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)customerOrgCreateDto.getParentCode())) {
            CustomerOrg parent = this.customerOrgRepository.findDetailsByCode(customerOrgCreateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.getRuleCodeByParentCode(customerOrgCreateDto.getParentCode());
        customerOrg.setRuleCode(ruleCode);
        customerOrg.setLevelNum(levelNum);
        this.customerOrgRepository.save((Object)customerOrg);
        CustomerOrgVo customerOrgVo = (CustomerOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrg, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendCreateEvent(Collections.singletonList(customerOrgVo));
        CustomerOrgEventDto customerOrgEventDto = (CustomerOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrg, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable nebulaEvent = CustomerOrgNebulaEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerOrgEventDto, CustomerOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        return customerOrgVo;
    }

    private String getRuleCodeByParentCode(String parentCode) {
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            CustomerOrg parent = this.customerOrgRepository.findDetailsByCode(parentCode, TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<CustomerOrg> childrenListByParentCode = this.customerOrgRepository.findChildrenListByParentCode(parentCode, TenantUtils.getTenantCode());
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, CustomerOrg.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(3, parentRuleCode, (List)childrenDto);
    }

    @Override
    @Transactional
    public CustomerOrgVo update(CustomerOrgUpdateDto customerOrgUpdateDto) {
        return this.updateForm(customerOrgUpdateDto);
    }

    private CustomerOrgVo updateForm(CustomerOrgUpdateDto customerOrgUpdateDto) {
        this.helper.updateValidation(customerOrgUpdateDto);
        if (StringUtils.isBlank((CharSequence)customerOrgUpdateDto.getParentCode())) {
            customerOrgUpdateDto.setParentCode(null);
        }
        CustomerOrg customerOrg = this.customerOrgRepository.findDetailsById(customerOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)customerOrgUpdateDto.getParentCode())) {
            CustomerOrg parent = this.customerOrgRepository.findDetailsByCode(customerOrgUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        CustomerOrg customerOrgNew = (CustomerOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrgUpdateDto, CustomerOrg.class, HashSet.class, ArrayList.class, new String[0]));
        this.customerOrgRepository.updateById((Object)customerOrgNew);
        if (StringUtils.isBlank((CharSequence)customerOrgUpdateDto.getParentCode())) {
            this.customerOrgRepository.setParentCodeNull(customerOrgUpdateDto.getId());
        }
        boolean updateRuleCode = false;
        String enableStatusChangeTo = "";
        if (!(customerOrg.getParentCode() == null ? "" : customerOrg.getParentCode()).equals(customerOrgUpdateDto.getParentCode() == null ? "" : customerOrgUpdateDto.getParentCode())) {
            updateRuleCode = true;
        }
        if (!customerOrg.getEnableStatus().equals(customerOrgUpdateDto.getEnableStatus())) {
            enableStatusChangeTo = customerOrgUpdateDto.getEnableStatus();
        }
        if (updateRuleCode) {
            String ruleCode = this.getRuleCodeByParentCode(customerOrgUpdateDto.getParentCode());
            this.updateCurAndChildrenRuleCode(customerOrgNew.getCustomerOrgCode(), ruleCode, levelNum);
        }
        if (StringUtils.isNotEmpty((CharSequence)enableStatusChangeTo)) {
            if (EnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
                this.enableBatch(Collections.singletonList(customerOrgNew.getId()));
            } else if (EnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
                this.disableBatch(Collections.singletonList(customerOrgNew.getId()));
            } else {
                throw new IllegalArgumentException("\u542f\u7528\u72b6\u6001\u9519\u8bef");
            }
        }
        customerOrg = this.customerOrgRepository.findDetailsById(customerOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        CustomerOrgVo customerOrgVo = (CustomerOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrg, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendUpdateEvent(Collections.singletonList(customerOrgVo));
        CustomerOrgEventDto oldCustomerOrgEventDto = (CustomerOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrgUpdateDto, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        CustomerOrgEventDto newCustomerOrgEventDto = (CustomerOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerOrg, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        CustomerOrgEventUpdateDto customerOrgEventUpdateDto = new CustomerOrgEventUpdateDto();
        customerOrgEventUpdateDto.setOldCustomerOrgEventDto(oldCustomerOrgEventDto);
        customerOrgEventUpdateDto.setNewCustomerOrgEventDto(newCustomerOrgEventDto);
        SerializableBiConsumer & Serializable nebulaEvent = CustomerOrgNebulaEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerOrgEventUpdateDto, CustomerOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        return customerOrgVo;
    }

    private void updateCurAndChildrenRuleCode(String customerOrgCode, String ruleCode, int levelNum) {
        CustomerOrg customerOrg = this.customerOrgRepository.findDetailsByCode(customerOrgCode, TenantUtils.getTenantCode());
        customerOrg.setRuleCode(ruleCode);
        customerOrg.setLevelNum(levelNum);
        this.customerOrgRepository.updateById((Object)customerOrg);
        List<CustomerOrg> childrenList = this.customerOrgRepository.findChildrenListByParentCode(customerOrgCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getCustomerOrgCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<CustomerOrg> customerOrgList = this.customerOrgRepository.findListByIds(ids, TenantUtils.getTenantCode()).stream().filter(x -> !EnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerOrgList)) {
            return;
        }
        List collect = customerOrgList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set parentRuleCodesExcludeSelf = treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(3, collect);
        if (!parentRuleCodesExcludeSelf.isEmpty()) {
            List parentList = this.customerOrgRepository.findListByRuleCodes(parentRuleCodesExcludeSelf, TenantUtils.getTenantCode()).stream().filter(customerOrg -> !EnableStatusEnum.ENABLE.getCode().equals(customerOrg.getEnableStatus()) && !ids.contains(customerOrg.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(parentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u5c42\u7ea7\uff0c\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u5c42\u7ea7", (Object[])new Object[0]);
        }
        customerOrgList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.customerOrgRepository.updateBatchById(customerOrgList);
        ArrayList customerOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgList, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendEnableEvent(customerOrgVos);
        ArrayList customerOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgList, CustomerOrg.class, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        CustomerOrgEventBatchDto customerOrgEventBatchDto = new CustomerOrgEventBatchDto();
        customerOrgEventBatchDto.setCustomerOrgEventDtoList((List)customerOrgEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = CustomerOrgNebulaEventListener::onEnableBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerOrgEventBatchDto, CustomerOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u7981\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<CustomerOrg> customerOrgList = this.customerOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(customerOrgList)) {
            return;
        }
        List<String> ruleCodes = customerOrgList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        List<CustomerOrg> childrenByRuleCodeList = this.customerOrgRepository.findCurAndChildrenByRuleCodeList(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(childrenByRuleCodeList)) {
            childrenByRuleCodeList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
            this.customerOrgRepository.updateBatchById(childrenByRuleCodeList);
            ArrayList customerOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenByRuleCodeList, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.helper.sendDisableEvent(customerOrgVos);
            ArrayList customerOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgList, CustomerOrg.class, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
            CustomerOrgEventBatchDto customerOrgEventBatchDto = new CustomerOrgEventBatchDto();
            customerOrgEventBatchDto.setCustomerOrgEventDtoList((List)customerOrgEventDtoList);
            SerializableBiConsumer & Serializable nebulaEvent = CustomerOrgNebulaEventListener::onDisableBatch;
            this.nebulaNetEventClient.publish((NebulaEventDto)customerOrgEventBatchDto, CustomerOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<CustomerOrg> customerOrgs = this.customerOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(customerOrgs) ? 1 : 0) != 0, (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        List<String> customerOrgCodeList = customerOrgs.stream().map(CustomerOrg::getCustomerOrgCode).collect(Collectors.toList());
        List childrenList = this.customerOrgRepository.findChildrenListByParentCodes(customerOrgCodeList, TenantUtils.getTenantCode()).stream().filter(o -> !ids.contains(o.getId())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(childrenList), (String)"\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7", (Object[])new Object[0]);
        for (CustomerOrg customerOrg : customerOrgs) {
            customerOrg.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        this.customerOrgRepository.updateBatchById(customerOrgs);
        for (CustomerOrg customerOrg : customerOrgs) {
            this.customerOrgRepository.setParentCodeAndRuleCodeNull(customerOrg.getId());
        }
        ArrayList customerOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgs, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendDeleteEvent(customerOrgVos);
        ArrayList customerOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgs, CustomerOrg.class, CustomerOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        CustomerOrgEventBatchDto customerOrgEventBatchDto = new CustomerOrgEventBatchDto();
        customerOrgEventBatchDto.setCustomerOrgEventDtoList((List)customerOrgEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = CustomerOrgNebulaEventListener::onDeleteBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)customerOrgEventBatchDto, CustomerOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Override
    @Transactional
    public void updateRuleCode() {
        this.customerOrgRepository.updateOrphanParentCodeNull(TenantUtils.getTenantCode());
        List<CustomerOrg> topList = this.customerOrgRepository.findListWithoutParentCode(TenantUtils.getTenantCode());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(topList.get(i).getCustomerOrgCode(), treeRuleCodeStrategy.generateByNum(3, i + 1), 1);
        }
    }

    @Override
    public List<CustomerOrgVo> findAll() {
        List<CustomerOrg> all = this.customerOrgRepository.findAll(TenantUtils.getTenantCode());
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(all, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    public List<CustomerOrgVo> findCurAndChildrenByOrgCodeList(List<String> orgCodes) {
        if (!CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<CustomerOrg> customerOrgs = this.customerOrgRepository.findCurAndChildrenByOrgCodeList(orgCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(customerOrgs)) {
            return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgs, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return null;
    }

    @Override
    public CustomerOrg findByCustomerOrgCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.customerOrgRepository.findByCustomerOrgCode(code);
    }

    @Override
    public List<CustomerOrg> findByCustomerOrgCodes(List<String> code) {
        if (CollectionUtils.isEmpty(code)) {
            return new ArrayList<CustomerOrg>();
        }
        return this.customerOrgRepository.findByCustomerOrgCodes(code);
    }
}

