package com.biz.crm.mdm.business.customer.org.local.repository;
/**
 * Created by Bao Hongbin on 2021-11-01 16:48.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.local.mapper.CustomerOrgPositionMapper;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.events.Event;

import java.util.List;

/**
 * @program: crm
 * @description: 客户组织和职位关联数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-11-01 16:48
 **/
@Component
public class CustomerOrgPositionRepository extends ServiceImpl<CustomerOrgPositionMapper, CustomerOrgPosition> {

  /**
   * 更加客户组织编码和职位集合删除关联关系
   *
   * @param customerOrgCode
   * @param positionCodeList
   */
  public void removeRelationByCustomerOrgCodeAndPositionCodes(String customerOrgCode, List<String> positionCodeList, String tenantCode) {
    Validate.notEmpty(customerOrgCode, "客户组织编码必须传入！");
    Validate.isTrue(!CollectionUtils.isEmpty(positionCodeList),
        "需要关联的职位编码不能为空！");
    this.lambdaUpdate()
        .eq(CustomerOrgPosition::getTenantCode, tenantCode)
        .eq(CustomerOrgPosition::getCustomerOrgCode, customerOrgCode)
        .in(CustomerOrgPosition::getPositionCode, positionCodeList)
        .remove();
  }

  /**
   * 通过职位编码查询与客户组织的关联关系
   *
   * @param positionCode
   * @param tenantCode
   * @return
   */
  public List<CustomerOrgPosition> findListByPositionCode(List<String> positionCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerOrgPosition::getTenantCode, tenantCode)
        .in(CustomerOrgPosition::getPositionCode, positionCode).list();
  }

  /**
   * 通过客户组织编码集合查找与职位的关联关系
   *
   * @param customerOrgCodes
   * @param tenantCode
   * @return
   */
  public List<CustomerOrgPosition> findListByCustomerOrgCodes(List<String> customerOrgCodes, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerOrgPosition::getTenantCode, tenantCode)
        .in(CustomerOrgPosition::getCustomerOrgCode, customerOrgCodes).list();
  }

  /**
   * 重构删除方法  通过ids和租户编号删除
   * @param ids
   */
  public void deleteByIdsAndTenantCode(List<String> ids,String tenantCode) {
    this.lambdaUpdate()
        .eq(CustomerOrgPosition::getTenantCode,tenantCode)
        .in(CustomerOrgPosition::getId, ids)
        .remove();
  }
}
