package com.biz.crm.mdm.business.customer.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 18:07.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgTreeVoService;
import com.biz.crm.mdm.business.customer.org.sdk.common.constant.CustomerOrgConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 客户组织载树服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 18:07
 **/
@Service
public class CustomerOrgTreeVoServiceImpl implements CustomerOrgTreeVoService {
  @Autowired(required = false)
  private CustomerOrgRepository customerOrgRepository;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;


  @Override
  public List<TreeVo> findTree(TreeDto treeDto) {
    treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
    List<TreeVo> tree = new ArrayList<>();
    List<CustomerOrg> list = customerOrgRepository.findListLikeName(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(list)) {
      return tree;
    }
    if (StringUtils.isNotEmpty(treeDto.getName())) {
      //查询所有符合的
      TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
      Set<String> set = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(
          CustomerOrgConstant.RULE_CODE_LENGTH, list.stream().map(CustomerOrg::getRuleCode).collect(Collectors.toList()));
      if (!CollectionUtils.isEmpty(set)) {
        List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
        list = new ArrayList<>();
        for (List<String> part : partition) {
          list.addAll(customerOrgRepository.findListByRuleCodes(new HashSet<>(part), TenantUtils.getTenantCode()));
        }
      }
    }
    List<TreeVo> collect = list.stream().map(x -> {
      TreeVo treeVo = new TreeVo();
      treeVo.setId(x.getId());
      treeVo.setParentCode(x.getParentCode());
      treeVo.setCode(x.getCustomerOrgCode());
      treeVo.setName(x.getCustomerOrgName());
      return treeVo;
    }).collect(Collectors.toList());
    tree = TreeUtil.generateTreeByParentCode(collect);
    if (StringUtils.isNotEmpty(treeDto.getExcludeCodeAndChildren())) {
      TreeUtil.excludeCodeAndChildren(tree, treeDto.getExcludeCodeAndChildren());
    }
    return tree;
  }


}
