package com.biz.crm.mdm.business.customer.org.local.notifier;
/**
 * Created by Bao Hongbin on 2021-10-12 17:15.
 */

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgPositionVoService;
import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 客户组织关联职位监听客户组织事件
 * @author: Bao Hongbin
 **/
@Component
@Slf4j
public class CustomerOrgEventPositionListenerImpl implements CustomerOrgEventListener {
  @Autowired(required = false)
  private CustomerOrgPositionVoService customerOrgPositionVoService;

  @Override
  public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {

  }

  @Override
  public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {

  }

  /**
   * 删除客户组织时判断是否存在与职位的关联
   *
   * @param customerOrgVos
   */
  @Override
  public void onBatchDelete(List<CustomerOrgVo> customerOrgVos) {
    if (CollectionUtils.isEmpty(customerOrgVos)) {
      return;
    }
    List<String> customerOrgCodes =
        customerOrgVos.stream().map(CustomerOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    List<CustomerOrgPosition> customerOrgPositions =
        customerOrgPositionVoService.findListByCustomerOrgCodes(customerOrgCodes);
    Validate.isTrue(CollectionUtils.isEmpty(customerOrgPositions), "存在客户组织和职位的关联，无法删除！");
  }

  @Override
  public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {

  }

  @Override
  public void onBatchDisable(List<CustomerOrgVo> eventDtos) {

  }
}
