package com.biz.crm.mdm.business.customer.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 10:21.
 */

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @program: crm
 * @description: 客户组织vo SDK 服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 10:21
 **/
@Service
public class CustomerOrgVoSdkServiceImpl implements CustomerOrgVoSdkService {
  @Autowired(required = false)
  private CustomerOrgRepository customerOrgRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 基于数据库执行的数据视图执行内容缓存（最多500毫秒）
   */
  private static volatile Cache<String, List<CustomerOrgVo>> cache = null;

  public CustomerOrgVoSdkServiceImpl(){
    if(cache == null) {
      synchronized (CustomerOrgVoSdkServiceImpl.class) {
        while(cache == null) {
          cache = CacheBuilder.newBuilder()
                  .initialCapacity(10000)
                  .expireAfterWrite(500, TimeUnit.MILLISECONDS)
                  .maximumSize(100000)
                  .build();
        }
      }
    }
  }

  @Override
  public List<CustomerOrgVo> findListByCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return Lists.newLinkedList();
    }
    String cacheKey = StringUtils.join(TenantUtils.getTenantCode(), codes);
    List<CustomerOrgVo> graph = cache.getIfPresent(cacheKey);
    if (graph == null) {
      List<CustomerOrg> customerOrgs = customerOrgRepository.findListByCodes(codes, TenantUtils.getTenantCode());
      if (CollectionUtils.isEmpty(customerOrgs)) {
        return Lists.newLinkedList();
      }
      graph = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(customerOrgs,
              CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class));
      cache.put(cacheKey, graph);
    }
    return graph;
  }
}
