package com.biz.crm.mdm.business.customer.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-11-01 16:47.
 */

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgPositionRepository;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgPositionVoService;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPositionBindDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-01 16:47
 **/
@Service
public class CustomerOrgPositionVoServiceImpl implements CustomerOrgPositionVoService {
  @Autowired(required = false)
  private CustomerOrgPositionRepository customerOrgPositionRepository;

  @Override
  @Transactional
  public void unbindPosition(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "当进行解绑操作时，业务技术编号信息必须传入");
    //删除数据
    customerOrgPositionRepository.removeByIds(ids);
  }

  @Override
  @Transactional
  public void bindPosition(CustomerOrgPositionBindDto customerOrgPositionBindDto) {
    //1.验证关联参数
    validateRelation(customerOrgPositionBindDto);
    //2.删除旧关联关系
    if (StringUtils.isNotBlank(customerOrgPositionBindDto.getOldCustomerOrgCode())) {
      customerOrgPositionRepository.removeRelationByCustomerOrgCodeAndPositionCodes(
          customerOrgPositionBindDto.getOldCustomerOrgCode(), customerOrgPositionBindDto.getPositionCodeList(), TenantUtils.getTenantCode());
    }
    //3.设置新关联关系
    List<CustomerOrgPosition> customerOrgPositions =
        customerOrgPositionBindDto.getPositionCodeList().stream().map(positionCode -> {
          CustomerOrgPosition customerOrgPosition = new CustomerOrgPosition();
          customerOrgPosition.setTenantCode(TenantUtils.getTenantCode());
          customerOrgPosition.setPositionCode(positionCode);
          customerOrgPosition.setCustomerOrgCode(customerOrgPositionBindDto.getCustomerOrgCode());
          return customerOrgPosition;
        }).collect(Collectors.toList());
    customerOrgPositionRepository.saveOrUpdateBatch(customerOrgPositions);

  }

  @Override
  public List<CustomerOrgPosition> findListByCustomerOrgCodes(List<String> customerOrgCodes) {
    if (CollectionUtils.isEmpty(customerOrgCodes)) {
      return null;
    }
    return customerOrgPositionRepository.findListByCustomerOrgCodes(customerOrgCodes, TenantUtils.getTenantCode());
  }

  private void validateRelation(CustomerOrgPositionBindDto customerOrgPositionBindDto) {
    Validate.notEmpty(customerOrgPositionBindDto.getCustomerOrgCode(), "客户组织编码必须传入！");
    Validate.isTrue(!CollectionUtils.isEmpty(customerOrgPositionBindDto.getPositionCodeList()),
        "需要关联的职位编码不能为空！");
  }
}
