package com.biz.crm.mdm.business.customer.org.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-27 17:48.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgPositionVoService;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPositionBindDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm
 * @description: 客户组织职位控制器
 * @author: Bao Hongbin
 * @create: 2021-10-27 17:48
 **/
@Api(tags = "客户组织：CustomerOrgPositionVo：客户组织关联职位的相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/customerOrg/position")
public class CustomerOrgPositionVoController {
  @Autowired(required = false)
  private CustomerOrgPositionVoService customerOrgPositionVoService;


  /**
   * 关联客户组织和职位
   */
  @ApiOperation(value = "关联客户组织和职位")
  @PostMapping(value = "/bind")
  public Result<?> bindPosition(
      @RequestBody @ApiParam(name = "customerOrgPositionBindDto",
          value = "关联客户组织和职位") CustomerOrgPositionBindDto customerOrgPositionBindDto) {
    try {
      this.customerOrgPositionVoService.bindPosition(customerOrgPositionBindDto);
      return Result.ok("关联成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 删除客户组织和职位关联
   */
  @ApiOperation(value = "删除客户组织和职位关联")
  @DeleteMapping("/unbind")
  public Result<?> unbindPosition(@RequestParam("ids") List<String> ids) {
    try {
      this.customerOrgPositionVoService.unbindPosition(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
