package com.biz.crm.mdm.business.customer.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.JdbcType;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户组织实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerOrg", description = "客户组织实体类")
@TableName("mdm_customer_org")
@Entity
@Table(name = "mdm_customer_org", indexes = {
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX1", columnList = "customer_org_code", unique = true),
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX2", columnList = "parent_code"),
    @Index(name = "MDM_PRODUCT_LEVEL_INDEX3", columnList = "rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_org", comment = "客户组织表")
public class CustomerOrg extends TenantFlagTreeOpEntity {

  private static final long serialVersionUID = -1674819897603635039L;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @TableField(value = "customer_org_code", jdbcType = JdbcType.VARCHAR)
  @Column(name = "customer_org_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户组织编码 '")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  @TableField(value = "customer_org_name")
  @Column(name = "customer_org_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织名称 '")
  private String customerOrgName;

  /**
   * 客户组织层级
   */
  @ApiModelProperty("客户组织层级")
  @TableField(value = "customer_org_level")
  @Column(name = "customer_org_level", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户组织层级 '")
  private String customerOrgLevel;

  /**
   * 客户组织类型
   */
  @ApiModelProperty("客户组织类型")
  @TableField(value = "customer_org_type")
  @Column(name = "customer_org_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户组织类型 '")
  private String customerOrgType;

  /**
   * 客户组织描述
   */
  @ApiModelProperty("客户组织描述")
  @TableField(value = "customer_org_desc")
  @Column(name = "customer_org_desc", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织描述 '")
  private String customerOrgDesc;

  /**
   * 上级编码
   */
  @ApiModelProperty("上级编码")
  @TableField(value = "parent_code",jdbcType = JdbcType.VARCHAR)
  @Column(name = "parent_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上级编码 '")
  private String parentCode;

}
