/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.org.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.mapper.CustomerOrgMapper;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPaginationDto;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class CustomerOrgRepository
extends ServiceImpl<CustomerOrgMapper, CustomerOrg> {
    public List<CustomerOrg> findListByName(String customerOrgName, boolean isLike, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgName, (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(!isLike, CustomerOrg::getCustomerOrgName, (Object)customerOrgName)).like(isLike, CustomerOrg::getCustomerOrgName, (Object)customerOrgName)).list();
    }

    public CustomerOrg findDetailsByCode(String customerOrgCode, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (CustomerOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(CustomerOrg::getCustomerOrgCode, (Object)customerOrgCode)).one());
    }

    public List<CustomerOrg> findListByCode(String customerOrgCode, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(CustomerOrg::getCustomerOrgCode, (Object)customerOrgCode)).list();
    }

    public CustomerOrg findDetailsById(String id, String tenantCode) {
        Validate.notBlank((CharSequence)id, (String)"\u5ba2\u6237\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (CustomerOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidEntity::getId, (Object)id)).one());
    }

    public List<CustomerOrg> findChildrenListByParentCode(String parentCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(!StringUtils.isNotEmpty((CharSequence)parentCode), CustomerOrg::getParentCode)).eq(StringUtils.isNotEmpty((CharSequence)parentCode), CustomerOrg::getParentCode, (Object)parentCode)).list();
    }

    public List<CustomerOrg> findListByIds(List<String> ids, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }

    public List<CustomerOrg> findListByRuleCodes(Set<String> ruleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).list();
    }

    public List<CustomerOrg> findCurAndChildrenByRuleCodeList(List<String> ruleCodes, String enableStatus, String tenantCode) {
        return ((CustomerOrgMapper)this.baseMapper).findCurAndChildrenByRuleCodeList(ruleCodes, enableStatus, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<CustomerOrg> findChildrenListByParentCodes(List<String> parentCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerOrg::getParentCode, parentCodes)).list();
    }

    public void updateOrphanParentCodeNull(String tenantCode) {
        ((CustomerOrgMapper)this.baseMapper).updateOrphanParentCodeNull(tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<CustomerOrg> findListWithoutParentCode(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(CustomerOrg::getParentCode)).list();
    }

    public List<CustomerOrg> findAll(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public Page<CustomerOrgVo> findByConditions(Pageable pageable, CustomerOrgPaginationDto customerOrgPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((CustomerOrgMapper)this.baseMapper).findByConditions((Page<CustomerOrgVo>)page, customerOrgPaginationDto, DelFlagStatusEnum.NORMAL);
    }

    public List<LazyTreeVo> findLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((CustomerOrgMapper)this.baseMapper).findLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<CustomerOrg> findListLikeName(String enableStatus, String name, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(StringUtils.isNotEmpty((CharSequence)name), CustomerOrg::getCustomerOrgName, (Object)name)).list();
    }

    public List<CustomerOrg> findListByCodes(List<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerOrg::getCustomerOrgCode, codes)).list();
    }

    public List<CustomerOrg> findCurAndChildrenByOrgCodeList(List<String> orgCodes, String enableStatus, String tenantCode) {
        return ((CustomerOrgMapper)this.baseMapper).findCurAndChildrenByOrgCodeList(orgCodes, enableStatus, tenantCode);
    }

    public void setParentCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(CustomerOrg::getParentCode, null)).eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void setParentCodeAndRuleCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(CustomerOrg::getParentCode, null)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)"")).eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public CustomerOrg findByCustomerOrgCode(String code) {
        return (CustomerOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(CustomerOrg::getCustomerOrgCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<CustomerOrg> findByCustomerOrgCodes(List<String> code) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CustomerOrg::getCustomerOrgCode, code)).list();
    }

    public void updateByIdAndTenantCode(CustomerOrg customerOrgNew, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{customerOrgNew.getId()});
        ((CustomerOrgMapper)this.baseMapper).update((Object)customerOrgNew, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(List<CustomerOrg> customerOrgList, String tenantCode) {
        customerOrgList.stream().forEach(customerOrg -> {
            LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
            lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
            lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{customerOrg.getId()});
            ((CustomerOrgMapper)this.baseMapper).update(customerOrg, (Wrapper)lambdaUpdateWrapper);
        });
    }

    public String findRuleCodeByCustomerOrgCode(String customerOrgCode) {
        CustomerOrg customerOrg = (CustomerOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(CustomerOrg::getCustomerOrgCode, (Object)customerOrgCode)).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).one());
        if (ObjectUtils.isEmpty((Object)((Object)customerOrg))) {
            return null;
        }
        return customerOrg.getRuleCode();
    }
}

