/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.org.local.service.internal;

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgPositionRepository;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgPositionVoService;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgPositionBindDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerOrgPositionVoServiceImpl
implements CustomerOrgPositionVoService {
    @Autowired(required=false)
    private CustomerOrgPositionRepository customerOrgPositionRepository;

    @Override
    @Transactional
    public void unbindPosition(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u89e3\u7ed1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        this.customerOrgPositionRepository.deleteByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void bindPosition(CustomerOrgPositionBindDto customerOrgPositionBindDto) {
        this.validateRelation(customerOrgPositionBindDto);
        if (StringUtils.isNotBlank((CharSequence)customerOrgPositionBindDto.getOldCustomerOrgCode())) {
            this.customerOrgPositionRepository.removeRelationByCustomerOrgCodeAndPositionCodes(customerOrgPositionBindDto.getOldCustomerOrgCode(), customerOrgPositionBindDto.getPositionCodeList(), TenantUtils.getTenantCode());
        }
        List customerOrgPositions = customerOrgPositionBindDto.getPositionCodeList().stream().map(positionCode -> {
            CustomerOrgPosition customerOrgPosition = new CustomerOrgPosition();
            customerOrgPosition.setTenantCode(TenantUtils.getTenantCode());
            customerOrgPosition.setPositionCode((String)positionCode);
            customerOrgPosition.setCustomerOrgCode(customerOrgPositionBindDto.getCustomerOrgCode());
            return customerOrgPosition;
        }).collect(Collectors.toList());
        this.customerOrgPositionRepository.saveOrUpdateBatch(customerOrgPositions);
    }

    @Override
    public List<CustomerOrgPosition> findListByCustomerOrgCodes(List<String> customerOrgCodes) {
        if (CollectionUtils.isEmpty(customerOrgCodes)) {
            return null;
        }
        return this.customerOrgPositionRepository.findListByCustomerOrgCodes(customerOrgCodes, TenantUtils.getTenantCode());
    }

    private void validateRelation(CustomerOrgPositionBindDto customerOrgPositionBindDto) {
        Validate.notEmpty((CharSequence)customerOrgPositionBindDto.getCustomerOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)customerOrgPositionBindDto.getPositionCodeList()) ? 1 : 0) != 0, (String)"\u9700\u8981\u5173\u8054\u7684\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

