/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.org.local.service.internal;

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerOrgVoSdkServiceImpl
implements CustomerOrgVoSdkService {
    @Autowired(required=false)
    private CustomerOrgRepository customerOrgRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<CustomerOrgVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomerOrgVoSdkServiceImpl() {
        if (cache != null) return;
        Class<CustomerOrgVoSdkServiceImpl> clazz = CustomerOrgVoSdkServiceImpl.class;
        synchronized (CustomerOrgVoSdkServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<CustomerOrgVo> findListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), codes});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            List<CustomerOrg> customerOrgs = this.customerOrgRepository.findListByCodes(codes, TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(customerOrgs)) {
                return Lists.newLinkedList();
            }
            graph = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgs, CustomerOrg.class, CustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
            cache.put((Object)cacheKey, (Object)graph);
        }
        return graph;
    }
}

