package com.biz.crm.mdm.business.customer.org.sdk.dto;
/**
 * Created by Bao Hongbin on 2021-10-27 17:37.
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: crm
 * @description: 客户组织分页查询dto
 * @author: Bao Hongbin
 * @create: 2021-10-27 17:37
 **/
@Data
@ApiModel("客户组织分页查询dto")
public class CustomerOrgPaginationDto {

  /**
   * id
   */
  private String id;

  /**
   * 租户编号
   */
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  private String enableStatus;

  /**
   * 备注
   */
  private String remark;

  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;

  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
  private String modifyAccount;

  @ApiModelProperty(name = "modifyName", value = "更新人名称")
  private String modifyName;

  @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;

  @ApiModelProperty(name = "ruleCode", value = "规则code查询用")
  private String ruleCode;

  @ApiModelProperty(name = "levelNum", value = "层级等级查询用")
  private Integer levelNum;

  @ApiModelProperty("ID集合")
  private List<String> ids;

  @ApiModelProperty(value = "客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty(value = "客户组织名称")
  private String customerOrgName;

  @ApiModelProperty(value = "客户组织层级")
  private String customerOrgLevel;

  @ApiModelProperty(value = "客户组织类型")
  private String customerOrgType;

  @ApiModelProperty(value = "客户组织描述")
  private String customerOrgDesc;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty("客户组织名称，模糊查询编码或名称")
  private String customerOrgCodeOrName;

  @ApiModelProperty("客户组织编码，只查询当前客户组织及下级")
  private String underCustomerOrgCode;

  @ApiModelProperty("客户组织编码，排除当前层级和下级")
  private String notUnderCustomerOrgCode;

  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private String selectedCode;

  @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodeList;

  /**
   * 客户组织ruleCode，只查询当前客户组织及下级
   */
  private String underThisRuleCode;

  /**
   * 客户组织ruleCode，排除当前客户组织及下级
   */
  private String notUnderThisRuleCode;
}
