package com.biz.crm.mdm.business.customer.org.sdk.event;

import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;

import java.util.List;

/**
 * 客户组织事件监听
 * Created by Bao Hongbin on 2021-10-12 16:55.
 */
public interface CustomerOrgEventListener {
  /**
   * 当新增客户组织时通知监听
   *
   * @param customerOrgVos
   */
  void onBatchCreate(List<CustomerOrgVo> customerOrgVos);

  /**
   * 当更新客户组织时通知监听
   *
   * @param customerOrgVos
   */
  void onBatchUpdate(List<CustomerOrgVo> customerOrgVos);

  /**
   * 当删除客户组织时通知监听
   *
   * @param customerOrgVos
   */
  void onBatchDelete(List<CustomerOrgVo> customerOrgVos);

  /**
   * 当启用客户组织时通知监听
   *
   * @param customerOrgVos
   */
  void onBatchEnable(List<CustomerOrgVo> customerOrgVos);


  /**
   * 当禁用客户组织时通知监听
   *
   * @param eventDtos
   */
  void onBatchDisable(List<CustomerOrgVo> eventDtos);

}
