package com.biz.crm.mdm.business.customer.org.sdk.event;

import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventBatchDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventDto;
import com.biz.crm.mdm.business.customer.org.sdk.dto.CustomerOrgEventUpdateDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 经销商组织关系事件监听器
 *
 * @author pengxi
 */
public interface CustomerOrgNebulaEventListener extends NebulaEvent {

  /**
   * 当新增经销商与组织关系时触发更新事件
   *
   * @param customerOrgEventDto
   */
  void onCreate(CustomerOrgEventDto customerOrgEventDto);

  /**
   * 当删除一批组织时触发删除事件
   *
   * @param customerOrgEventBatchDto
   */
  void onDeleteBatch(CustomerOrgEventBatchDto customerOrgEventBatchDto);

  /**
   * 当启用一批组织时触发批量启用事件
   *
   * @param customerOrgEventBatchDto
   */
  void onEnableBatch(CustomerOrgEventBatchDto customerOrgEventBatchDto);

  /**
   * 当禁用一批组织时触发批量禁用事件
   *
   * @param customerOrgEventBatchDto
   */
  void onDisableBatch(CustomerOrgEventBatchDto customerOrgEventBatchDto);

  /**
   * 当修改组织时触发更新事件
   *
   * @param customerOrgEventUpdateDto
   */
  void onUpdate(CustomerOrgEventUpdateDto customerOrgEventUpdateDto);
}
