package com.biz.crm.mdm.business.customer.retailer.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.retailer.feign.feign.internal.CustomerRetailerVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 客户零售商feign
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 20:57
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = CustomerRetailerVoServiceFeignImpl.class)
public interface CustomerRetailerVoServiceFeign {
    /**
     * 查询分页列表
     *
     * @param page 分页信息
     * @param size 分页信息
     * @param dto  查询参数
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:51
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo/findByConditions"})
    Result<Page<CustomerRetailerVo>> findByConditions(
            @RequestParam("page") Integer page,
            @RequestParam("size") Integer size,
            @SpringQueryMap CustomerRetailerDto dto);



    /**
     * 零售商下拉框查询接口
     * @param page 分页信息
     * @param size 分页信息
     * @param dto 查询参数
     * @return  零售商列表
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo//findByRetailerSelectDto"})
    Result<Page<CustomerRetailerVo>> findByRetailerSelectDto(
            @RequestParam("page") Integer page,
            @RequestParam("size") Integer size,
            @SpringQueryMap CustomerRetailerSelectDto dto);


    /**
     * 批量新增或修改
     *
     * @param dtoList
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:27
     */
    @ApiOperation(value = "批量新增或修改")
    @PostMapping("/v1/customerRetailer/customerRetailerVo/createOrUpdate")
    Result<List<CustomerRetailerVo>> createOrUpdate(@RequestBody List<CustomerRetailerDto> dtoList);

    /**
     * 新增
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:27
     */
    @ApiOperation(value = "新增")
    @PostMapping("/v1/customerRetailer/customerRetailerVo/create")
    Result<CustomerRetailerVo> create(@ApiParam(name = "dto", value = "客户零售商") @RequestBody CustomerRetailerDto dto);

    /**
     * 修改
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:27
     */
    @ApiOperation(value = "修改")
    @PatchMapping("/v1/customerRetailer/customerRetailerVo/update")
    Result<CustomerRetailerVo> update(@ApiParam(name = "dto", value = "客户零售商") @RequestBody CustomerRetailerDto dto);

    /**
     * 删除
     *
     * @param idList
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:27
     */
    @ApiOperation(value = "删除")
    @DeleteMapping("/v1/customerRetailer/customerRetailerVo/delete")
    Result<?> delete(@ApiParam(name = "idList", value = "idList") @RequestParam("idList") List<String> idList);


    /**
     * 启用
     *
     * @param ids
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:27
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/v1/customerRetailer/customerRetailerVo/enable")
    Result<?> enable(@RequestBody List<String> ids);


    /**
     * 禁用
     *
     * @param ids
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 18:28
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/v1/customerRetailer/customerRetailerVo/disable")
    Result<?> disable(@RequestBody List<String> ids);

    /**
     * 根据id获取信息
     *
     * @param id 员工ID
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id获取信息")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo/findById"})
    Result<CustomerRetailerVo> findById(@RequestParam("id") String id);

    /**
     * 根据id集合获取信息
     *
     * @param idList ID集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id集合获取信息")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo/findByIds"})
    Result<List<CustomerRetailerVo>> findByIds(@RequestParam("idList") List<String> idList);

    /**
     * 根据编码获取信息
     *
     * @param code 编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据编码获取信息")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo/findByCode"})
    Result<CustomerRetailerVo> findByCode(@RequestParam("code") String code);

    /**
     * 根据编码获取信息
     *
     * @param codeList 编码集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据编码集合获取信息")
    @GetMapping(value = {"/v1/customerRetailer/customerRetailerVo/findByCodes"})
    Result<List<CustomerRetailerVo>> findByCodes(@RequestParam("codeList") List<String> codeList);

    /**
     * 获取所有零售商编码
     *
     * @return Result<List < String>>
     */
    @ApiOperation(value = "获取所有零售商编码")
    @PostMapping("/v1/customerRetailer/customerRetailerVo/getAllRetailerCode")
    Result<Map<String,String>> getAllRetailerCode();

    /**
     * 获取所有零售商编码
     *
     * @return Result<Map<String,Stirng>>
     */
    @ApiOperation(value = "获取所有零售商编码(名称，编码)")
    @PostMapping("/v1/customerRetailer/customerRetailerVo/getAllRetailerNameCode")
    Result<Map<String,String>> getAllRetailerNameCode();

    /**
     * 根据编码列表获取零售商名称
     *
     * @param codes 零售商编码列表
     * @return List < String>
     */
    @ApiOperation(value = "根据编码列表获取零售商名称")
    @PostMapping("/v1/customerRetailer/customerRetailerVo/getRetailerByCodes")
    Result<Map<String, String>> getRetailerByCodes(@RequestBody List<String> codes);
    /**
     * 根据名称查询零售商编码
     *
     * @param retailerName
     * @return
     */
    @ApiOperation(value = "根据名称查询零售商编码")
    @GetMapping("/v1/customerRetailer/customerRetailerVo/findByName")
    public Result<List<String>> findByName(@RequestParam("retailerName") String retailerName);
}
