package com.biz.crm.mdm.business.customer.retailer.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.retailer.feign.feign.CustomerRetailerVoServiceFeign;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * feign熔断实现
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 20:59
 */
@Component
public class CustomerRetailerVoServiceFeignImpl implements FallbackFactory<CustomerRetailerVoServiceFeign> {

    @Override
    public CustomerRetailerVoServiceFeign create(Throwable throwable) {
        return new CustomerRetailerVoServiceFeign() {
            @Override
            public Result<Page<CustomerRetailerVo>> findByConditions(Integer page, Integer size, CustomerRetailerDto dto) {
                throw new UnsupportedOperationException("分页查询客户零售商熔断");
            }

            @Override
            public Result<Page<CustomerRetailerVo>> findByRetailerSelectDto(Integer page, Integer size, CustomerRetailerSelectDto dto) {
                throw new UnsupportedOperationException("下拉框查询客户零售商熔断");
            }

            @Override
            public Result<List<CustomerRetailerVo>> createOrUpdate(List<CustomerRetailerDto> dtoList) {
                throw new UnsupportedOperationException("批量新增或更新客户零售商熔断");
            }

            @Override
            public Result<CustomerRetailerVo> create(CustomerRetailerDto dto) {
                throw new UnsupportedOperationException("新增客户零售商熔断");
            }

            @Override
            public Result<CustomerRetailerVo> update(CustomerRetailerDto dto) {
                throw new UnsupportedOperationException("更新客户零售商熔断");
            }

            @Override
            public Result<?> delete(List<String> idList) {
                throw new UnsupportedOperationException("根据ID集合删除客户零售商熔断");
            }

            @Override
            public Result<?> enable(List<String> ids) {
                throw new UnsupportedOperationException("根据ID集合启用客户零售商熔断");
            }

            @Override
            public Result<?> disable(List<String> ids) {
                throw new UnsupportedOperationException("根据ID集合禁用客户零售商熔断");
            }

            @Override
            public Result<CustomerRetailerVo> findById(String id) {
                throw new UnsupportedOperationException("根据ID查询客户零售商熔断");
            }

            @Override
            public Result<List<CustomerRetailerVo>> findByIds(List<String> idList) {
                throw new UnsupportedOperationException("根据ID集合查询客户零售商熔断");
            }

            @Override
            public Result<CustomerRetailerVo> findByCode(String code) {
                throw new UnsupportedOperationException("根据编码查询客户零售商熔断");
            }

            @Override
            public Result<List<CustomerRetailerVo>> findByCodes(List<String> codeList) {
                throw new UnsupportedOperationException("根据编码集合查询客户零售商熔断");
            }

            @Override
            public Result<Map<String,String>> getAllRetailerCode() {
                throw new UnsupportedOperationException("查询全部零售商编码熔断");
            }

            @Override
            public Result<Map<String, String>> getAllRetailerNameCode() {
                throw new UnsupportedOperationException("查询全部零售商编码熔断");
            }

            @Override
            public Result<Map<String, String>> getRetailerByCodes(List<String> codes) {
                throw new UnsupportedOperationException("根据编码列表获取零售商名称熔断");
            }

            @Override
            public Result<List<String>> findByName(String retailerName) {
                throw new UnsupportedOperationException("根据名称查询零售商编码熔断");
            }
        };
    }
}
