package com.biz.crm.mdm.business.customer.retailer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.retailer.feign.feign.CustomerRetailerVoServiceFeign;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 客户零售商信息(CustomerRetailer)表服务实现类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 23:13
 */
@Slf4j
@Service
public class CustomerRetailerVoServiceImpl implements CustomerRetailerVoService {

    @Autowired(required = false)
    private CustomerRetailerVoServiceFeign customerRetailerVoServiceFeign;

    /**
     * 查询分页列表
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:52
     */
    @Override
    public Page<CustomerRetailerVo> findByConditions(Pageable pageable, CustomerRetailerDto dto) {
        Result<Page<CustomerRetailerVo>> result = customerRetailerVoServiceFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


    /**
     * 零售商下拉框查询接口
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return 零售商列表
     */
    @Override
    public Page<CustomerRetailerVo> findByCustomerSelectDto(Pageable pageable, CustomerRetailerSelectDto dto) {
        Result<Page<CustomerRetailerVo>> result = customerRetailerVoServiceFeign.findByRetailerSelectDto(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 按id查询详情
     *
     * @param id 员工ID
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:09
     */
    @Override
    public CustomerRetailerVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.findById(id);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 按id集合查询详情
     *
     * @param idList 员工ID集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:09
     */
    @Override
    public List<CustomerRetailerVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByIds(idList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 按编码查询详情
     *
     * @param code 编码
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:09
     */
    @Override
    public CustomerRetailerVo findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.findByCode(code);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


    /**
     * 按编码集合查询详情
     *
     * @param codeList 编码集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:09
     */
    @Override
    public List<CustomerRetailerVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByCodes(codeList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 批量新增或修改
     *
     * @param dtoList 数据集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 16:42
     */
    @Override
    public List<CustomerRetailerVo> createOrUpdate(List<CustomerRetailerDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.createOrUpdate(dtoList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @Override
    public CustomerRetailerVo create(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.create(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();

    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @Override
    public CustomerRetailerVo update(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        Validate.notBlank(dto.getCustomerRetailerCode(), "编码不能为空！");
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.update(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 删除
     *
     * @param idList
     */
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        Result result = this.customerRetailerVoServiceFeign.delete(idList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
    }

    /**
     * 基础共同校验
     *
     * @param dto
     */
    private void commonValidate(CustomerRetailerDto dto) {
        Validate.notNull(dto, "参数不能为空！");
        Validate.notBlank(dto.getCustomerRetailerName(), "名称不能为空！");
    }

    /**
     * 批量启用
     *
     * @param ids ID集合
     */
    @Override
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, "待启用的数据主键不能为空");
        Result result = customerRetailerVoServiceFeign.enable(ids);
        Assert.isTrue(result.isSuccess(), result.getMessage());
    }

    /**
     * 批量禁用
     *
     * @param ids ID集合
     */
    @Override
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, "待禁用的数据主键不能为空");
        Result result = customerRetailerVoServiceFeign.disable(ids);
        Assert.isTrue(result.isSuccess(), result.getMessage());
    }

    @Override
    public List<CommonSelectVo> findCustomerRetailerSelectList(CommonSelectDto dto) {
        throw new UnsupportedOperationException("");
    }

    /**
     * 获取所有零售商编码
     *
     * @return List < String>
     */
    @Override
    public Map<String, String> getAllRetailerCode() {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getAllRetailerCode();
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, String> getAllRetailerNameCode() {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getAllRetailerNameCode();
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据编码列表获取零售商名称
     *
     * @param codes 零售商编码列表
     * @return List < String>
     */
    @Override
    public Map<String, String> getRetailerByCodes(List<String> codes) {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getRetailerByCodes(codes);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }
    /**
     * 根据名称查询零售商编码
     *
     * @param retailerName
     * @return
     */
    @Override
    public List<String> findByName(String retailerName) {
        Result<List<String>> result = this.customerRetailerVoServiceFeign.findByName(retailerName);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


}
