/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.retailer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.retailer.feign.feign.CustomerRetailerVoServiceFeign;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CustomerRetailerVoServiceImpl
implements CustomerRetailerVoService {
    private static final Logger log = LoggerFactory.getLogger(CustomerRetailerVoServiceImpl.class);
    @Autowired(required=false)
    private CustomerRetailerVoServiceFeign customerRetailerVoServiceFeign;

    public Page<CustomerRetailerVo> findByConditions(Pageable pageable, CustomerRetailerDto dto) {
        Result<Page<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Page)result.getResult();
    }

    public Page<CustomerRetailerVo> findByCustomerSelectDto(Pageable pageable, CustomerRetailerSelectDto dto) {
        Result<Page<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByRetailerSelectDto(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Page)result.getResult();
    }

    public CustomerRetailerVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.findById(id);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (CustomerRetailerVo)result.getResult();
    }

    public List<CustomerRetailerVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByIds(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public CustomerRetailerVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.findByCode(code);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (CustomerRetailerVo)result.getResult();
    }

    public List<CustomerRetailerVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.findByCodes(codeList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<CustomerRetailerVo> createOrUpdate(List<CustomerRetailerDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerRetailerVo>> result = this.customerRetailerVoServiceFeign.createOrUpdate(dtoList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public CustomerRetailerVo create(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.create(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (CustomerRetailerVo)result.getResult();
    }

    public CustomerRetailerVo update(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        Validate.notBlank((CharSequence)dto.getCustomerRetailerCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<CustomerRetailerVo> result = this.customerRetailerVoServiceFeign.update(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (CustomerRetailerVo)result.getResult();
    }

    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<?> result = this.customerRetailerVoServiceFeign.delete(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    private void commonValidate(CustomerRetailerDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerRetailerName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.customerRetailerVoServiceFeign.enable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.customerRetailerVoServiceFeign.disable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public List<CommonSelectVo> findCustomerRetailerSelectList(CommonSelectDto dto) {
        throw new UnsupportedOperationException("");
    }

    public Map<String, String> getAllRetailerCode() {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getAllRetailerCode();
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Map)result.getResult();
    }

    public Map<String, String> getAllRetailerNameCode() {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getAllRetailerNameCode();
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Map)result.getResult();
    }

    public Map<String, String> getRetailerByCodes(List<String> codes) {
        Result<Map<String, String>> result = this.customerRetailerVoServiceFeign.getRetailerByCodes(codes);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Map)result.getResult();
    }

    public List<String> findByName(String retailerName) {
        Result<List<String>> result = this.customerRetailerVoServiceFeign.findByName(retailerName);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }
}

