package com.biz.crm.mdm.business.customer.retailer.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照零售商维度授权
 */
@Component("retailerAuthorityModeGroupRegister")
public class RetailerAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {
  @Override
  public String groupCode() {
    return "retailer_group";
  }

  @Override
  public String groupName() {
    return "按照零售商维度授权";
  }

  @Override
  public Set<String> viewFieldNames() {
    return Sets.newHashSet("customerRetailerCodes", "customerRetailerCode","customer_retailer_code");
  }

  @Override
  public Set<String> repositoryFieldNames() {
    return Sets.newHashSet("customerRetailerCodes", "customerRetailerCode","customer_retailer_code");
  }
}
