package com.biz.crm.mdm.business.customer.retailer.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照固定零售商
 */
@Component("retailerAuthorityModeRegisterForSelect")
public class RetailerAuthorityModeRegisterForSelect implements SelectAuthorityModeRegister {

    @Override
    public String modeKey() {
        return "retailerAuthorityModeRegisterForSelect";
    }

    @Override
    public String modeName() {
        return "按照固定零售商进行零售商维度的值确认";
    }

    @Override
    public String controlKey() {
        return "retailerAuthorityModeRegisterForSelect";
    }

    @Override
    public int sort() {
        return 20;
    }

    @Override
    public String groupCode() {
        return "retailer_group";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return staticValues;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        return null;
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }
}
