package com.biz.crm.mdm.business.customer.retailer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 客户零售商管理
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 23:41
 */
@Slf4j
@Api(value = "客户信息零售商管理", tags = "MDM-客户信息-零售商管理VO")
@RestController
@RequestMapping(value = {"/v1/customerRetailer/customerRetailerVo"})
public class CustomerRetailerVoController {

    @Autowired(required = false)
    private CustomerRetailerVoService promotersVoService;
    /**
     * 查询分页列表
     *
     * @param pageable 分页信息
     * @param dto      查询参数
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:51
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<CustomerRetailerVo>> findByConditions(@PageableDefault(50) Pageable pageable, CustomerRetailerDto dto) {
        try {
            Page<CustomerRetailerVo> result = this.promotersVoService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 零售商下拉框查询接口
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return  零售商列表
     */
    @ApiOperation(value = "零售商信息下拉框分页列表")
    @GetMapping("/findByRetailerSelectDto")
    public Result<Page<CustomerRetailerVo>> findByCustomerSelectDto(@PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "CustomerRetailerDto", value = "下拉分页Dto") CustomerRetailerSelectDto dto) {
        try {
            return Result.ok(promotersVoService.findByCustomerSelectDto(pageable, dto));
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "批量新增或修改")
    @PostMapping("createOrUpdate")
    public Result<List<CustomerRetailerVo>> createOrUpdate(@RequestBody List<CustomerRetailerDto> dtoList) {
        try {
            List<CustomerRetailerVo> result = this.promotersVoService.createOrUpdate(dtoList);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "新增")
    @PostMapping("create")
    public Result<CustomerRetailerVo> create(@ApiParam(name = "dto", value = "客户零售商") @RequestBody CustomerRetailerDto dto) {
        try {
            CustomerRetailerVo result = this.promotersVoService.create(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "修改")
    @PatchMapping("update")
    public Result<CustomerRetailerVo> update(@ApiParam(name = "dto", value = "客户零售商") @RequestBody CustomerRetailerDto dto) {
        try {
            CustomerRetailerVo result = this.promotersVoService.update(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除")
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "ID集合") @RequestParam("idList") List<String> idList) {
        try {
            this.promotersVoService.delete(idList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PatchMapping("enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.promotersVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.promotersVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id获取信息
     *
     * @param id 员工ID
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id获取信息")
    @GetMapping(value = {"/findById"})
    public Result<CustomerRetailerVo> findById(@RequestParam("id") String id) {
        try {
            CustomerRetailerVo list = this.promotersVoService.findById(id);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id集合获取信息
     *
     * @param idList ID集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id集合获取信息")
    @GetMapping(value = {"/findByIds"})
    public Result<List<CustomerRetailerVo>> findByIds(@RequestParam("idList") List<String> idList) {
        try {
            List<CustomerRetailerVo> list = this.promotersVoService.findByIds(idList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据编码获取信息
     *
     * @param code 员工编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据编码获取信息")
    @GetMapping(value = {"/findByCode"})
    public Result<CustomerRetailerVo> findByCode(@RequestParam("code") String code) {
        try {
            CustomerRetailerVo list = this.promotersVoService.findByCode(code);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据编码获取信息
     *
     * @param codeList 编码集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据编码集合获取信息")
    @GetMapping(value = {"/findByCodes"})
    public Result<List<CustomerRetailerVo>> findByCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<CustomerRetailerVo> list = this.promotersVoService.findByCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 零售商下拉
     * @param dto 零售商查询参数
     */
    @ApiOperation(value = "零售商下拉")
    @PostMapping("findCustomerRetailerSelectList")
    public Result<List<CommonSelectVo>> findCustomerRetailerSelectList(@ApiParam(value = "活动类型dto")@RequestBody CommonSelectDto dto){
        try {
            List<CommonSelectVo> list = promotersVoService.findCustomerRetailerSelectList(dto);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取所有零售商编码
     *
     * @return Result<Map<String,Stirng>>
     */
    @ApiOperation(value = "获取所有零售商编码")
    @PostMapping("getAllRetailerCode")
    public Result<Map<String,String>> getAllRetailerCode() {
        try {
            Map<String,String> map = promotersVoService.getAllRetailerCode();
            return Result.ok(map);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取所有零售商编码
     *
     * @return Result<Map<String,Stirng>>
     */
    @ApiOperation(value = "获取所有零售商编码(名称，编码)")
    @PostMapping("getAllRetailerNameCode")
    public Result<Map<String,String>> getAllRetailerNameCode() {
        try {
            Map<String,String> map = promotersVoService.getAllRetailerNameCode();
            return Result.ok(map);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据编码列表获取零售商名称
     *
     * @param codes 零售商编码列表
     * @return List < String>
     */
    @ApiOperation(value = "根据编码列表获取零售商名称")
    @PostMapping("getRetailerByCodes")
    public Result<Map<String, String>> getRetailerByCodes(@RequestBody List<String> codes) {
        try {
            Map<String, String> map = promotersVoService.getRetailerByCodes(codes);
            return Result.ok(map);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据名称查询零售商编码
     *
     * @param retailerName
     * @return
     */
    @ApiOperation(value = "根据名称查询零售商编码")
    @GetMapping("/findByName")
    public Result<List<String>> findByName(@RequestParam("retailerName") String retailerName) {
        try {
            List<String> list = promotersVoService.findByName(retailerName);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
