package com.biz.crm.mdm.business.customer.retailer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户零售商实体
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 21:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(
        name = "mdm_customer_retailer",
        indexes = {
                @Index(name = "mdm_customer_retailer_index1", columnList = "customer_retailer_code", unique = true),
        })
@TableName(value = "mdm_customer_retailer")
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_retailer", comment = "客户零售商实体类")
public class CustomerRetailer extends TenantFlagOpEntity {


    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    @TableField(value = "customer_retailer_code")
    @Column(name = "customer_retailer_code", columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    @TableField(value = "customer_retailer_name")
    @Column(name = "customer_retailer_name", nullable = false, columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;
}
