package com.biz.crm.mdm.business.customer.retailer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author: chenlong
 * @date: 2022/11/22 14:16
 * @description: 零售商业务单元关系表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerRetailerBusinessUnitRelation", description = "零售商业务单元关系表")
@TableName("mdm_customer_retailer_business_unit_relation")
@Entity
@Table(name = "mdm_customer_retailer_business_unit_relation", indexes = {
    @Index(name = "MDM_CUSTOMER_RETAILER_BUSINESS_UNIT_RELATION_INDEX1", columnList = "customer_retailer_code"),
    @Index(name = "MDM_CUSTOMER_RETAILER_BUSINESS_UNIT_RELATION_INDEX2", columnList = "business_unit_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_retailer_business_unit_relation", comment = "零售商业务单元关系表")
public class CustomerRetailerBusinessUnitRelation extends TenantFlagOpEntity {

    /**
     * 产品品牌编码
     */
    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    @TableField(value = "customer_retailer_code")
    @Column(name = "customer_retailer_code", columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_unit] '")
    private String businessUnitCode;
}
