package com.biz.crm.mdm.business.customer.retailer.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailerBusinessUnitRelation;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description
 * @Author YangWei
 * @Date 2023/4/4 下午2:11
 */
@Component
public class CustomerRetailerHelper {

    /**
     * 构建零售商业务单元关系
     * @param dto
     * @return {@link List}<{@link CustomerRetailerBusinessUnitRelation}>
     */
    public List<CustomerRetailerBusinessUnitRelation> buildRelations(CustomerRetailerDto dto) {
        List<CustomerRetailerBusinessUnitRelation> relations = Lists.newArrayList();
        dto.getBusinessUnitCodes().forEach(bfCode -> {
            CustomerRetailerBusinessUnitRelation relation = new CustomerRetailerBusinessUnitRelation();
            relation.setCustomerRetailerCode(dto.getCustomerRetailerCode());
            relation.setBusinessUnitCode(bfCode);
            relation.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            relation.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            relation.setTenantCode(TenantUtils.getTenantCode());
            relations.add(relation);
        });
        return relations;
    }
}