package com.biz.crm.mdm.business.customer.retailer.local.interceptor;

import com.biz.crm.mdm.business.businessunit.sdk.constant.BusinessUnitConstant;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailerBusinessUnitRelation;
import com.biz.crm.mdm.business.customer.retailer.local.repository.CustomerRetailerBusinessUnitRelationRepository;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description 零售商数据图字段扩展
 * @Author YangWei
 * @Date 2023/2/7 上午10:02
 */
@Slf4j
@Component
public class CustomerRetailerInterceptor implements ExternalQueryInterceptor {

    //扩展字段
    private static final String BUSINESS_UNIT_CODE = "business_unit_code";

    @Resource
    private CustomerRetailerBusinessUnitRelationRepository customerRetailerBusinessUnitRelationRepository;

    @Override
    public String code() {
        return "mdm_customer_retailer_business_unit_code";
    }

    @Override
    public String name() {
        return "业务单元扩展";
    }

    @Resource
    private DictDataVoService dictDataVoService;

    @Override
    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
        //查询结果
        List<Map<String, Object>> results = executeContent.getResults();
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        //查询业务单元数据字典
        List<DictDataVo> businessFormat = this.dictDataVoService.findByDictTypeCode(BusinessUnitConstant.MDM_BUSINESS_UNIT);
        Map<String, DictDataVo> businessUnitMap = businessFormat.stream()
            .collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        //循环获取品牌集合
        Set<String> customerRetailerCodes = Sets.newHashSet();
        results.forEach(item -> {
            String customerRetailerCode = (String) item.get("customer_retailer_code");
            customerRetailerCodes.add(customerRetailerCode);
        });
        //查询零售商和业务单元关系
        List<CustomerRetailerBusinessUnitRelation> businessUnitRelations = this.customerRetailerBusinessUnitRelationRepository
            .findByCustomerRetailerCodes(customerRetailerCodes);
        Map<String, List<CustomerRetailerBusinessUnitRelation>> relationMap = businessUnitRelations.stream()
            .collect(Collectors.groupingBy(CustomerRetailerBusinessUnitRelation::getCustomerRetailerCode));
        //数据处理
        List<Object[]> contents = Lists.newArrayList();
        results.forEach(item -> {
            List<Object> businessUnitNameArray = Lists.newArrayList();
            String customerRetailerCode = (String) item.get("customer_retailer_code");
            List<CustomerRetailerBusinessUnitRelation> entities = relationMap.get(customerRetailerCode);
            if(CollectionUtils.isEmpty(entities)){
                businessUnitNameArray.add("");
            }else{
                List<String> businessUnitCodes = entities.stream()
                    .map(CustomerRetailerBusinessUnitRelation::getBusinessUnitCode).collect(Collectors.toList());
                List<String> businessUnitNameList = Lists.newArrayList();
                businessUnitCodes.forEach(formatCode -> {
                    DictDataVo dictDataVo = businessUnitMap.get(formatCode);
                    if(!ObjectUtils.isEmpty(dictDataVo)){
                        businessUnitNameList.add(dictDataVo.getDictValue());
                    }
                });
                String businessUnitNameStr = String.join("/", businessUnitNameList);
                businessUnitNameArray.add(businessUnitNameStr);
            }
            contents.add(businessUnitNameArray.toArray(new Object[]{}));
        });
        return contents;
    }
}