package com.biz.crm.mdm.business.customer.retailer.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 客户零售商 信息(CustomerRetailer)表数据库访问层
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 22:30
 */
public interface CustomerRetailerMapper extends BaseMapper<CustomerRetailer> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<CustomerRetailerVo> findByConditions(Page<CustomerRetailerVo> page, @Param("dto") CustomerRetailerDto dto);

    Page<CustomerRetailerVo> findByCustomerSelectDto(Page<CustomerRetailerVo> page, @Param("dto") CustomerRetailerSelectDto dto);

    List<CommonSelectVo> findCustomerRetailerSelectList(@Param("dto") CommonSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 获取所有零售商编码
     *
     * @param tenantCode 租户
     * @return List < CommonSelectVo>
     */
    List<CommonSelectVo> getAllRetailerCode(@Param("tenantCode") String tenantCode);


    /**
     * 根据编码列表获取零售商名称
     *
     * @param codeList   零售商编码列表
     * @param tenantCode 租户
     * @return List < CustomerRetailerVo>
     */
    List<CustomerRetailerVo> getRetailerByCodes(@Param("codeList") List<List<String>> codeList, @Param("tenantCode") String tenantCode);

    /**
     * 根据名称查询零售商编码
     *
     * @param retailerName
     * @return
     */
    List<String> findByName(@Param("retailerName") String retailerName);

    /**
     * 条件查询
     * @param dto
     * @return {@link List}<{@link CustomerRetailerVo}>
     */
    List<CustomerRetailerVo> findByCustomerRetailerDto(@Param("dto") CustomerRetailerDto dto);
}
