package com.biz.crm.mdm.business.customer.retailer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailerBusinessUnitRelation;
import com.biz.crm.mdm.business.customer.retailer.local.mapper.CustomerRetailerBusinessUnitRelationMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;

/**
 * 客户零售商信息(repository)
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 22:53
 */
@Component
public class CustomerRetailerBusinessUnitRelationRepository extends ServiceImpl<CustomerRetailerBusinessUnitRelationMapper, CustomerRetailerBusinessUnitRelation> {

    /**
     * 保存关系数据
     * @param customerRetailerCode
     * @param relations
     */
    public void saveRelations(String customerRetailerCode, List<CustomerRetailerBusinessUnitRelation> relations) {
        //先删除
        this.delByCustomerRetailerCode(customerRetailerCode);
        if(CollectionUtils.isEmpty(relations)){
            return;
        }
        this.saveBatch(relations);
    }

    /**
     * 根据零售商删除
     * @param customerRetailerCode
     */
    public void delByCustomerRetailerCode(String customerRetailerCode) {
        this.lambdaUpdate()
            .eq(CustomerRetailerBusinessUnitRelation::getCustomerRetailerCode, customerRetailerCode)
            .remove();
    }

    /**
     * 查询零售商和业务单元关系
     * @param customerRetailerCodes
     * @return {@link List}<{@link CustomerRetailerBusinessUnitRelation}>
     */
    public List<CustomerRetailerBusinessUnitRelation> findByCustomerRetailerCodes(Set<String> customerRetailerCodes) {
        return this.lambdaQuery().in(CustomerRetailerBusinessUnitRelation::getCustomerRetailerCode, customerRetailerCodes)
            .eq(CustomerRetailerBusinessUnitRelation::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(CustomerRetailerBusinessUnitRelation::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
            .eq(CustomerRetailerBusinessUnitRelation::getTenantCode, TenantUtils.getTenantCode())
            .list();
    }
}
