/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.retailer.local.interceptor;

import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailerBusinessUnitRelation;
import com.biz.crm.mdm.business.customer.retailer.local.repository.CustomerRetailerBusinessUnitRelationRepository;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class CustomerRetailerInterceptor
implements ExternalQueryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CustomerRetailerInterceptor.class);
    private static final String BUSINESS_UNIT_CODE = "business_unit_code";
    @Resource
    private CustomerRetailerBusinessUnitRelationRepository customerRetailerBusinessUnitRelationRepository;
    @Resource
    private DictDataVoService dictDataVoService;

    public String code() {
        return "mdm_customer_retailer_business_unit_code";
    }

    public String name() {
        return "\u4e1a\u52a1\u5355\u5143\u6269\u5c55";
    }

    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String ... strings) {
        List results = executeContent.getResults();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        List businessFormat = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        Map businessUnitMap = businessFormat.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        HashSet customerRetailerCodes = Sets.newHashSet();
        results.forEach(item -> {
            String customerRetailerCode = (String)item.get("customer_retailer_code");
            customerRetailerCodes.add(customerRetailerCode);
        });
        List<CustomerRetailerBusinessUnitRelation> businessUnitRelations = this.customerRetailerBusinessUnitRelationRepository.findByCustomerRetailerCodes(customerRetailerCodes);
        Map<String, List<CustomerRetailerBusinessUnitRelation>> relationMap = businessUnitRelations.stream().collect(Collectors.groupingBy(CustomerRetailerBusinessUnitRelation::getCustomerRetailerCode));
        ArrayList contents = Lists.newArrayList();
        results.forEach(item -> {
            ArrayList businessUnitNameArray = Lists.newArrayList();
            String customerRetailerCode = (String)item.get("customer_retailer_code");
            List entities = (List)relationMap.get(customerRetailerCode);
            if (CollectionUtils.isEmpty((Collection)entities)) {
                businessUnitNameArray.add("");
            } else {
                List<String> businessUnitCodes = entities.stream().map(CustomerRetailerBusinessUnitRelation::getBusinessUnitCode).collect(Collectors.toList());
                ArrayList businessUnitNameList = Lists.newArrayList();
                businessUnitCodes.forEach(formatCode -> {
                    DictDataVo dictDataVo = (DictDataVo)businessUnitMap.get(formatCode);
                    if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
                        businessUnitNameList.add(dictDataVo.getDictValue());
                    }
                });
                String businessUnitNameStr = String.join((CharSequence)"/", businessUnitNameList);
                businessUnitNameArray.add(businessUnitNameStr);
            }
            contents.add(businessUnitNameArray.toArray(new Object[0]));
        });
        return contents;
    }
}

