/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.retailer.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer;
import com.biz.crm.mdm.business.customer.retailer.local.mapper.CustomerRetailerMapper;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class CustomerRetailerRepository
extends ServiceImpl<CustomerRetailerMapper, CustomerRetailer> {
    public Page<CustomerRetailerVo> findByConditions(Page<CustomerRetailerVo> page, CustomerRetailerDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerRetailerMapper)this.baseMapper).findByConditions(page, dto);
    }

    public CustomerRetailer findById(String id) {
        if (!StringUtils.hasText((String)id)) {
            return null;
        }
        return (CustomerRetailer)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CustomerRetailer> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public CustomerRetailer findByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return null;
        }
        return (CustomerRetailer)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomerRetailer::getCustomerRetailerCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CustomerRetailer> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomerRetailer::getCustomerRetailerCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Integer countByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerRetailer::getCustomerRetailerCode, (Object)code)).count();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Page<CustomerRetailerVo> findByCustomerSelectDto(Page<CustomerRetailerVo> page, CustomerRetailerSelectDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerRetailerMapper)this.baseMapper).findByCustomerSelectDto(page, dto);
    }

    public List<CommonSelectVo> findCustomerRetailerSelectList(CommonSelectDto dto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return ((CustomerRetailerMapper)this.baseMapper).findCustomerRetailerSelectList(dto, 50);
    }

    public List<CommonSelectVo> getAllRetailerCode(String tenantCode) {
        return ((CustomerRetailerMapper)this.baseMapper).getAllRetailerCode(tenantCode);
    }

    public List<CustomerRetailerVo> getRetailerByCodes(List<List<String>> codeList, String tenantCode) {
        return ((CustomerRetailerMapper)this.baseMapper).getRetailerByCodes(codeList, tenantCode);
    }

    public List<String> findByName(String retailerName) {
        return ((CustomerRetailerMapper)this.baseMapper).findByName(retailerName);
    }

    public List<CustomerRetailerVo> findByCodeOrName(List<String> codeOrName) {
        Assert.notEmpty(codeOrName, (String)"\u7f16\u7801\u540d\u79f0\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CustomerRetailerDto dto = new CustomerRetailerDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCodeOrNameList(codeOrName);
        return ((CustomerRetailerMapper)this.baseMapper).findByCustomerRetailerDto(dto);
    }
}

