/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.retailer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailer;
import com.biz.crm.mdm.business.customer.retailer.local.entity.CustomerRetailerBusinessUnitRelation;
import com.biz.crm.mdm.business.customer.retailer.local.helper.CustomerRetailerHelper;
import com.biz.crm.mdm.business.customer.retailer.local.repository.CustomerRetailerBusinessUnitRelationRepository;
import com.biz.crm.mdm.business.customer.retailer.local.repository.CustomerRetailerRepository;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerEventDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.event.CustomerRetailerEventListener;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerRetailerVoServiceImpl
implements CustomerRetailerVoService {
    private static final Logger log = LoggerFactory.getLogger(CustomerRetailerVoServiceImpl.class);
    @Autowired(required=false)
    private CustomerRetailerRepository customerRetailerRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private CustomerRetailerBusinessUnitRelationRepository customerRetailerBusinessUnitRelationRepository;
    @Autowired(required=false)
    private CustomerRetailerHelper customerRetailerHelper;

    public Page<CustomerRetailerVo> findByConditions(Pageable pageable, CustomerRetailerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerRetailerDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.customerRetailerRepository.findByConditions((Page<CustomerRetailerVo>)page, dto);
    }

    public Page<CustomerRetailerVo> findByCustomerSelectDto(Pageable pageable, CustomerRetailerSelectDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerRetailerSelectDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page<CustomerRetailerVo> page = new Page<CustomerRetailerVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page = this.customerRetailerRepository.findByCustomerSelectDto(page, dto);
        return page;
    }

    public CustomerRetailerVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        CustomerRetailer promoters = this.customerRetailerRepository.findById(id);
        if (Objects.isNull((Object)promoters)) {
            return null;
        }
        return (CustomerRetailerVo)this.nebulaToolkitService.copyObjectByBlankList((Object)promoters, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerRetailerVo> findByIds(List<String> idList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<CustomerRetailer> promotersList = this.customerRetailerRepository.findByIds(idList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(promotersList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(promotersList, CustomerRetailer.class, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public CustomerRetailerVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        CustomerRetailer entity = this.customerRetailerRepository.findByCode(code);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        return (CustomerRetailerVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerRetailerVo> findByCodes(List<String> codeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<CustomerRetailer> entityList = this.customerRetailerRepository.findByCodes(codeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, CustomerRetailer.class, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CustomerRetailerVo> createOrUpdate(List<CustomerRetailerDto> dtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Set<String> codeSet = this.baseValAndBuild(dtoList);
        String redisKey = "mdm:lock:customer_retailer_code:";
        HashSet hasLockSet = new HashSet(codeSet.size());
        try {
            codeSet.forEach(code -> {
                boolean lock = this.redisMutexService.tryLock(redisKey + code, TimeUnit.MINUTES, 30);
                Assert.isTrue((boolean)lock, (String)("\u5ba2\u6237\u96f6\u552e\u5546[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
                hasLockSet.add(code);
            });
            List<CustomerRetailer> oldEntityList = this.customerRetailerRepository.findByCodes(new ArrayList<String>(codeSet));
            HashMap<String, CustomerRetailer> oldMap = new HashMap<String, CustomerRetailer>(codeSet.size());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(oldEntityList)) {
                oldEntityList.forEach(entity -> oldMap.put(entity.getCustomerRetailerCode(), (CustomerRetailer)((Object)entity)));
            }
            List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList, CustomerRetailerDto.class, CustomerRetailer.class, HashSet.class, ArrayList.class, new String[0]);
            List<CustomerRetailer> addList = this.buildAddMap(entityList, oldMap);
            List<CustomerRetailer> updateList = this.buildUpdateMap(entityList, oldMap);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addList)) {
                this.customerRetailerRepository.saveBatch(addList);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
                this.customerRetailerRepository.updateBatchById(updateList);
            }
            this.saveLog(addList, updateList, oldMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hasLockSet)) {
                hasLockSet.forEach(code -> this.redisMutexService.unlock(redisKey + code));
            }
        }
        List<CustomerRetailer> resultList = this.customerRetailerRepository.findByCodes(new ArrayList<String>(codeSet));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(resultList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(resultList, CustomerRetailer.class, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private Set<String> baseValAndBuild(List<CustomerRetailerDto> dtoList) {
        HashSet<String> codeSet = new HashSet<String>(dtoList.size());
        dtoList.forEach(dto -> {
            this.commonValidate((CustomerRetailerDto)dto);
            String code = dto.getCustomerRetailerCode();
            Assert.isTrue((!codeSet.contains(code) ? 1 : 0) != 0, (String)("\u5f53\u524d\u96c6\u5408\u5185\u7f16\u7801[" + code + "]\u91cd\u590d"));
            if (StringUtils.isEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getEnableStatus())) {
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            }
            dto.setTenantCode(TenantUtils.getTenantCode());
            codeSet.add(code);
        });
        return codeSet;
    }

    private void saveLog(List<CustomerRetailer> addList, List<CustomerRetailer> updateList, Map<String, CustomerRetailer> oldMap) {
        List list;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(addList, CustomerRetailer.class, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onCreate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(updateList, CustomerRetailer.class, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
                eventDto.setOriginal((CustomerRetailerDto)this.nebulaToolkitService.copyObjectByBlankList((Object)oldMap.getOrDefault(dto.getCustomerRetailerCode(), new CustomerRetailer()), CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]));
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
    }

    private List<CustomerRetailer> buildAddMap(List<CustomerRetailer> entityList, Map<String, CustomerRetailer> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<CustomerRetailer> result = new ArrayList<CustomerRetailer>(entityList.size());
        entityList.stream().filter(k -> !oldMap.containsKey(k.getCustomerRetailerCode())).filter(k -> Objects.isNull(oldMap.get(k.getCustomerRetailerCode()))).forEach(result::add);
        return result;
    }

    private List<CustomerRetailer> buildUpdateMap(List<CustomerRetailer> entityList, Map<String, CustomerRetailer> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<CustomerRetailer> result = new ArrayList<CustomerRetailer>(entityList.size());
        entityList.stream().filter(k -> oldMap.containsKey(k.getCustomerRetailerCode())).filter(k -> Objects.nonNull(oldMap.get(k.getCustomerRetailerCode()))).forEach(entity -> {
            CustomerRetailer oldEntity = (CustomerRetailer)((Object)((Object)oldMap.get(entity.getCustomerRetailerCode())));
            entity.setId(oldEntity.getId());
            entity.setCreateTime(oldEntity.getCreateTime());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setCreateAccount(oldEntity.getCreateAccount());
            result.add((CustomerRetailer)((Object)entity));
        });
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public CustomerRetailerVo create(CustomerRetailerDto dto) {
        this.createValidate(dto);
        String code = dto.getCustomerRetailerCode();
        String redisKey = "mdm:lock:customer_retailer_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u5ba2\u6237\u96f6\u552e\u5546[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            int count = this.customerRetailerRepository.countByCode(code);
            Assert.isTrue((count < 1 ? 1 : 0) != 0, (String)("\u5ba2\u6237\u96f6\u552e\u5546[" + code + "]\u5df2\u5b58\u5728,\u4e0d\u53ef\u65b0\u589e!"));
            CustomerRetailer entity = (CustomerRetailer)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, CustomerRetailer.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            if (!CollectionUtils.isEmpty((Collection)dto.getBusinessUnitCodes())) {
                entity.setBusinessUnitCode(String.join((CharSequence)",", dto.getBusinessUnitCodes()));
            }
            this.customerRetailerRepository.saveOrUpdate((Object)entity);
            List<CustomerRetailerBusinessUnitRelation> relations = this.customerRetailerHelper.buildRelations(dto);
            this.customerRetailerBusinessUnitRelationRepository.saveRelations(dto.getCustomerRetailerCode(), relations);
            CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
            eventDto.setOriginal(null);
            eventDto.setNewest((CustomerRetailerDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
            CustomerRetailerVo customerRetailerVo = (CustomerRetailerVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
            return customerRetailerVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CustomerRetailerVo update(CustomerRetailerDto dto) {
        this.updateValidate(dto);
        String code = dto.getCustomerRetailerCode();
        String redisKey = "mdm:lock:customer_retailer_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u5ba2\u6237\u96f6\u552e\u5546[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
            eventDto.setOriginal(dto);
            CustomerRetailer oldEntity = this.customerRetailerRepository.findByCode(code);
            Assert.notNull((Object)((Object)oldEntity), (String)("\u5ba2\u6237\u96f6\u552e\u5546[" + code + "]\u4e0d\u5b58\u5728,\u7f16\u8f91\u5931\u8d25!"));
            dto.setId(oldEntity.getId());
            CustomerRetailer entity = (CustomerRetailer)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, CustomerRetailer.class, HashSet.class, ArrayList.class, new String[0]));
            if (!CollectionUtils.isEmpty((Collection)dto.getBusinessUnitCodes())) {
                entity.setBusinessUnitCode(String.join((CharSequence)",", dto.getBusinessUnitCodes()));
            }
            this.customerRetailerRepository.saveOrUpdate((Object)entity);
            List<CustomerRetailerBusinessUnitRelation> relations = this.customerRetailerHelper.buildRelations(dto);
            this.customerRetailerBusinessUnitRelationRepository.saveRelations(dto.getCustomerRetailerCode(), relations);
            eventDto.setNewest((CustomerRetailerDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
            CustomerRetailerVo customerRetailerVo = (CustomerRetailerVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerRetailerVo.class, HashSet.class, ArrayList.class, new String[0]);
            return customerRetailerVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CustomerRetailer> entityList = this.customerRetailerRepository.findByIds(idList);
        entityList.forEach(entity -> {
            String code = entity.getCustomerRetailerCode();
            entity.setCustomerRetailerCode(code + entity.getId());
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.customerRetailerRepository.updateBatchById(entityList);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, CustomerRetailer.class, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    private void createValidate(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        dto.setId(null);
    }

    private void updateValidate(CustomerRetailerDto dto) {
        this.commonValidate(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustomerRetailer businessUnit = this.customerRetailerRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)businessUnit), (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)businessUnit.getCustomerRetailerCode().equals(dto.getCustomerRetailerCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01", (Object[])new Object[0]);
    }

    private void commonValidate(CustomerRetailerDto dto) {
        Validate.notBlank((CharSequence)dto.getCustomerRetailerCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerRetailerName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerRetailer> entityList = this.customerRetailerRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.customerRetailerRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, CustomerRetailer.class, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerRetailer> entityList = this.customerRetailerRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.customerRetailerRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, CustomerRetailer.class, CustomerRetailerDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(entity -> {
            CustomerRetailerEventDto eventDto = new CustomerRetailerEventDto();
            eventDto.setOriginal(entity);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = CustomerRetailerEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRetailerEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    public List<CommonSelectVo> findCustomerRetailerSelectList(CommonSelectDto dto) {
        return this.customerRetailerRepository.findCustomerRetailerSelectList(dto);
    }

    public Map<String, String> getAllRetailerCode() {
        List<CommonSelectVo> list = this.customerRetailerRepository.getAllRetailerCode(TenantUtils.getTenantCode());
        Map<String, String> map = new HashMap<String, String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(CommonSelectVo::getCode, CommonSelectVo::getValue));
        }
        return map;
    }

    public Map<String, String> getAllRetailerNameCode() {
        List<CommonSelectVo> list = this.customerRetailerRepository.getAllRetailerCode(TenantUtils.getTenantCode());
        Map<String, String> map = new HashMap<String, String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(CommonSelectVo::getValue, CommonSelectVo::getCode));
        }
        return map;
    }

    public Map<String, String> getRetailerByCodes(List<String> codes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codes)) {
            return Maps.newHashMap();
        }
        List list = Lists.partition(codes, (int)500);
        List<CustomerRetailerVo> vos = this.customerRetailerRepository.getRetailerByCodes(list, TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return Maps.newHashMap();
        }
        return vos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, CustomerRetailerVo::getCustomerRetailerName, (oldValue, newValue) -> newValue));
    }

    public List<String> findByName(String retailerName) {
        if (StringUtils.isEmpty((CharSequence)retailerName)) {
            return null;
        }
        return this.customerRetailerRepository.findByName(retailerName);
    }

    public List<CustomerRetailerVo> findByCodeOrName(List<String> codeOrName) {
        return this.customerRetailerRepository.findByCodeOrName(codeOrName);
    }
}

