package com.biz.crm.mdm.business.customer.retailer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * 客户零售商 dto
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 22:28
 */
@Data
@ApiModel(value = "CustomerRetailerDto", description = "客户零售商dto")
public class CustomerRetailerDto extends TenantFlagOpDto {


    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    private String customerRetailerName;

    @ApiModelProperty(name = "codeOrNameList", notes = "编码/名称")
    private List<String> codeOrNameList;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private List<String> businessUnitCodes;

}
