package com.biz.crm.mdm.business.customer.retailer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 客户零售商 dto
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 22:28
 */
@Data
@ApiModel(value = "CustomerRetailerDto", description = "客户零售商dto")
public class CustomerRetailerSelectDto extends TenantFlagOpDto {


    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    private String customerRetailerName;


    /**
     * 用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
     * "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
     */
    @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
            "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodes;


    /**
     * 编码名称模糊查询
     */
    @ApiModelProperty("编码名称模糊查询")
    private String keyWord;

}
