package com.biz.crm.mdm.business.customer.retailer.sdk.event;

import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 客户零售商 变更事件通知接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 18:23
 */
public interface CustomerRetailerEventListener extends NebulaEvent {


    /**
     * 当客户零售商创建时触发
     *
     * @param dto
     */
    default void onCreate(CustomerRetailerEventDto dto) {
    }

    /**
     * 当客户零售商修改时触发
     *
     * @param dto
     */
    default void onUpdate(CustomerRetailerEventDto dto) {
    }

    /**
     * 当客户零售商禁用时触发
     *
     * @param dto
     */
    default void onDisable(CustomerRetailerEventDto dto) {
    }

    /**
     * 当客户零售商启用时触发
     *
     * @param dto
     */
    default void onEnable(CustomerRetailerEventDto dto) {
    }

    /**
     * 当客户零售商删除时触发
     *
     * @param dto
     */
    default void onDelete(CustomerRetailerEventDto dto) {
    }

}
