package com.biz.crm.mdm.business.customer.retailer.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerSelectDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.google.common.collect.Lists;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 客户零售商信息Vo接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 23:15
 */
public interface CustomerRetailerVoService {

    /**
     * 查询分页列表
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:52
     */
    Page<CustomerRetailerVo> findByConditions(Pageable pageable, CustomerRetailerDto dto);


    /**
     * 零售商下拉框查询接口
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return 零售商列表
     */
    Page<CustomerRetailerVo> findByCustomerSelectDto(Pageable pageable, CustomerRetailerSelectDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    CustomerRetailerVo findById(String id);

    /**
     * 按id集合查询详情
     *
     * @param idList
     * @return
     */
    List<CustomerRetailerVo> findByIds(List<String> idList);

    /**
     * 按编码查询详情
     *
     * @param code 编码
     * @return
     */
    CustomerRetailerVo findByCode(String code);

    /**
     * 按编码集合查询详情
     *
     * @param codeList 编码集合
     * @return
     */
    List<CustomerRetailerVo> findByCodes(List<String> codeList);

    /**
     * 批量新增或修改
     *
     * @param dtoList 数据集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 16:42
     */
    List<CustomerRetailerVo> createOrUpdate(List<CustomerRetailerDto> dtoList);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    CustomerRetailerVo create(CustomerRetailerDto dto);

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    CustomerRetailerVo update(CustomerRetailerDto dto);

    /**
     * 删除
     *
     * @param idList
     * @return
     */
    void delete(List<String> idList);

    /**
     * 批量启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 零售商下拉
     *
     * @param dto 零售商查询参数
     */
    List<CommonSelectVo> findCustomerRetailerSelectList(CommonSelectDto dto);

    /**
     * 获取所有零售商编码
     *
     * @return List < String>
     */
    Map<String, String> getAllRetailerCode();

    /**
     * 获取所有的零售商
     * @return Map（零售商名称,零售商编码）
     */
    Map<String, String> getAllRetailerNameCode();

    /**
     * 根据编码列表获取零售商名称
     *
     * @param codes 零售商编码列表
     * @return List < String>
     */
    Map<String, String> getRetailerByCodes(List<String> codes);

    /**
     * 根据名称查询零售商编码
     *
     * @param retailerName
     * @return
     */
    List<String> findByName(String retailerName);

    /**
     * 根据编码或者名称查询
     * @param codeOrName
     * @return {@link List}<{@link CustomerRetailerVo}>
     */
    default List<CustomerRetailerVo> findByCodeOrName(List<String> codeOrName){
        return Lists.newArrayList();
    }
}
