package com.biz.crm.mdm.business.customer.retailer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 *  客户零售商
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 21:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class CustomerRetailerVo extends TenantFlagOpVo {


    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    private String customerRetailerName;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private List<String> businessUnitCodes;
}
