package com.biz.crm.mdm.business.customer.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 客户信息对接人Dto
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Data
@ApiModel(value = "CustomerDockingDto", description = "客户信息对接人Dto")
public class CustomerDockingDto {

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 联系方式
   */
  @ApiModelProperty("联系方式")
  private String contact;

  /**
   * 用户帐号
   */
  @ApiModelProperty("用户帐号")
  private String userName;

  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String fullName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty("销售公司编码")
  private String saleCompany;

  /**
   * 对接人供货关系列表
   */
  @ApiModelProperty("对接人供货关系列表")
  private List<CustomerDockingSupplyDto> mdmCustomerSupplyDetailList;

}