package com.biz.crm.mdm.business.customer.sdk.dto;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import java.util.Set;
import lombok.Data;

/**
 * 根据CustomerQueryDto获取匹配的客户编码
 *
 * @author sunx
 * @date 2022/5/27
 */
@Data
public class CustomerQueryDto {
  /** 客户编码 模糊查询 */
  private String customerCode;
  /** 客户名称 模糊查询 */
  private String customerName;
  /** 渠道编码 */
  private String channel;
  /** 组织名称模糊查询 */
  private String orgName;
  /** 删除标记 */
  private String delFlag = DelFlagStatusEnum.NORMAL.getCode();
  /** 审核状态 */
  private String processStatus = ActApproveStatusEnum.APPROVED.getCode();
  /** 客户编码集合 */
  private Set<String> customerCodeSet;
  /** 组织编码集合 */
  private Set<String> orgCodeSet;
}
