package com.biz.crm.mdm.business.customer.sdk.event;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 客户信息变更事件通知接口
 *
 * @author ning.zhang
 * @date 2021/10/27
 */
public interface CustomerEventListener extends NebulaEvent {

  /**
   * 当客户信息创建时触发
   *
   * @param dto
   */
  default void onCreate(CustomerEventDto dto) {}

  /**
   * 审批通过
   *
   * @param dto
   */
  default void onApproved(CustomerEventDto dto) {}

  /**
   * 当客户信息保存并提交时触发
   *
   * @param dto
   */
  default void onCreateAndSubmit(CustomerEventDto dto) {}

  /**
   * 当客户信息修改时触发
   *
   * @param dto
   */
  default void onUpdate(CustomerEventDto dto) {}

  /**
   * 当客户信息禁用时触发
   *
   * @param dto
   */
  default void onDisable(CustomerEventDto dto) {}

  /**
   * 当客户信息启用时触发
   *
   * @param dto
   */
  default void onEnable(CustomerEventDto dto) {}

  /**
   * 当客户信息删除时触发
   *
   * @param dto
   */
  default void onDelete(CustomerEventDto dto) {}

  /**
   * 当客户信息冻结时触发
   *
   * @param dto
   */
  default void onFreeze(CustomerEventDto dto) {}

  /**
   * 当客户信息解冻时触发
   *
   * @param dto
   */
  default void onUnfreeze(CustomerEventDto dto) {}
}
