package com.biz.crm.mdm.business.customer.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户开票信息Vo
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerBillVo", description = "客户开票信息Vo")
public class CustomerBillVo extends TenantVo {

  private static final long serialVersionUID = 8135587920514057183L;

  /**
   * 开票单位
   */
  @ApiModelProperty("开票单位")
  private String billCompany;

  /**
   * 税号
   */
  @ApiModelProperty("税号")
  private String taxNumber;

  /**
   * 法人
   */
  @ApiModelProperty("法人")
  private String legal;

  /**
   * 开户银行
   */
  @ApiModelProperty("开户银行")
  private String depositBank;

  /**
   * 银行帐号
   */
  @ApiModelProperty("银行帐号")
  private String bankAccount;

  /**
   * 是否是默认开票信息，1是0否
   */
  @ApiModelProperty("是否是默认开票信息(true:是,false:否)")
  private Boolean billMain;

}